/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.flightrecord;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.CartesianInfo;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.pin.rtde.RTDESubscriber;
import java.io.PrintStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class TcpParametersProbe
implements FlightRecorderProbe,
RTDESubscriber {
    private final Provider<CartesianInfo> cartesianInfoProvider;
    private boolean receivedCog;
    private double payload;
    private double[] cog = new double[3];

    @Inject
    public TcpParametersProbe(@Source(value=CartesianInfo.class) Recipe<CartesianInfo> cartesianInfoRecipe) {
        this.cartesianInfoProvider = cartesianInfoRecipe.lastProvider();
    }

    public String getName() {
        return "Active TCP Parameters";
    }

    public void write(PrintStream printStream) {
        CartesianInfo cartesianInfo = (CartesianInfo)this.cartesianInfoProvider.get();
        if (cartesianInfo != null) {
            printStream.println("TCP offset [m, rad]: " + cartesianInfo.getTcpOffset());
        }
        if (this.receivedCog) {
            printStream.println(String.format("Payload [kg]: %.2f", this.payload));
            printStream.println(String.format("Center of gravity [m]: [%.4f, %.4f, %.4f]", this.cog[0], this.cog[1], this.cog[2]));
        }
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        return Collections.emptyList();
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.CONTROLLER_REPORTED_ERROR);
    }

    public void handleMessage(byte[] bytes) {
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])bytes);
        this.payload = dataInput.readDouble();
        int i = 0;
        while (i < this.cog.length) {
            this.cog[i] = dataInput.readDouble();
            ++i;
        }
        this.receivedCog = true;
    }

    public String getRTDESetupMessage() {
        return "payload,payload_cog";
    }

    public int getMessageSize() {
        return 32;
    }
}

