/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.payload;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.internaltcp.impl.payload.InstallationPayloadConstraint;
import com.ur.polyscope.internaltcp.impl.payload.MaximumPayloadLookup;
import com.ur.polyscope.internaltcp.impl.payload.PayloadConstraint;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.internal.impl.TextResourceImpl;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import java.util.Locale;
import javax.inject.Inject;

public class MaximumPayloadForRobot
implements PayloadConstraint,
InstallationPayloadConstraint {
    private static final int MIN_PAYLOAD = 0;
    private final TextResource textResource;
    private final UnitsConverter kgConverter;
    private MaximumPayloadLookup lookup;
    private boolean isHardLimit = true;

    public MaximumPayloadForRobot(MaximumPayloadLookup maximumPayloadLookup) {
        this(maximumPayloadLookup, new TextResourceImpl(Locale.ENGLISH));
    }

    @Inject
    public MaximumPayloadForRobot(MaximumPayloadLookup lookup, TextResource textResource) {
        this.lookup = lookup;
        this.kgConverter = Units.getKgConverter();
        this.textResource = textResource;
    }

    public boolean isValid(String uncheckedString) {
        double maximumPayload = this.isHardLimit ? this.getMaxPayloadHardLimit() : this.getMaxPayloadSoftLimit();
        double payload = PrimitiveUtils.parseDouble((String)uncheckedString, (double)Double.MAX_VALUE);
        return PrimitiveUtils.isWithinRange((double)payload, (double)0.0, (double)maximumPayload);
    }

    public double getMaxPayloadHardLimit() {
        return this.kgConverter.convertFrom(this.lookup.getMaximumPayloadHardLimit().asDouble());
    }

    public double getMaxPayloadSoftLimit() {
        return this.kgConverter.convertFrom(this.lookup.getMaximumPayloadSoftLimit().asDouble());
    }

    public double getMinPayload() {
        return 0.0;
    }

    public String getErrorMessage(String uncheckedString) {
        block3: {
            try {
                if (!StringUtils.isNullOrOnlyWhitespace((String)uncheckedString) && !StringUtils.equalsAny((String)uncheckedString, (String[])new String[]{".", "-", "-."})) break block3;
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                return this.textResource.notANumber();
            }
        }
        PrimitiveUtils.parseDouble((String)uncheckedString);
        return this.textResource.ratedPayloadExceeded(this.getMaxPayloadSoftLimit(), this.kgConverter.getUnit());
    }

    @Override
    public void setIsHardLimit(boolean isHardLimit) {
        this.isHardLimit = isHardLimit;
    }
}

