/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.payload;

import com.ur.polyscope.internaltcp.impl.payload.MaximumPayloadForRobot;
import com.ur.polyscope.internaltcp.impl.payload.MaximumPayloadLookup;
import com.ur.polyscope.internaltcp.impl.payload.PayloadConstraint;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.internal.impl.TextResourceImpl;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.swing.validation.ValidationStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;

public class PayloadValidationStrategy
implements ValidationStrategy {
    private PayloadConstraint payloadConstraint;
    private String lastErrorMessage = "";
    private boolean isHardLimits = true;
    boolean isEmptyPayloadValueValid;
    @Inject
    static TextResource textResource = new TextResourceImpl(Locale.ENGLISH);

    public static PayloadValidationStrategy validator(RobotConfigurationProvider robot, PayloadConstraint ... constraints) {
        return new PayloadValidationStrategy(new HashSet<PayloadConstraint>(Arrays.asList(constraints)), robot, textResource);
    }

    @Inject
    public PayloadValidationStrategy(Set<PayloadConstraint> constraints, RobotConfigurationProvider robot, TextResource textResource) {
        if (constraints.size() == 1) {
            this.payloadConstraint = constraints.iterator().next();
        }
        if (constraints.isEmpty()) {
            this.payloadConstraint = new MaximumPayloadForRobot(new MaximumPayloadLookup(robot), textResource);
        } else {
            for (PayloadConstraint each : constraints) {
                if (each instanceof MaximumPayloadForRobot) continue;
                this.payloadConstraint = each;
                break;
            }
        }
    }

    public PayloadConstraint getPayloadConstraint() {
        return this.payloadConstraint;
    }

    public boolean isValid(String uncheckedString) {
        this.lastErrorMessage = "";
        this.payloadConstraint.setIsHardLimit(this.isHardLimits);
        if (this.isEmptyPayloadValueValid && uncheckedString.isEmpty()) {
            return true;
        }
        if (!this.payloadConstraint.isValid(uncheckedString)) {
            this.lastErrorMessage = this.payloadConstraint.getErrorMessage(uncheckedString);
            return false;
        }
        return true;
    }

    public String getErrorMessage(String uncheckedString) {
        return this.lastErrorMessage;
    }

    public void setHardLimits(boolean hardLimits) {
        this.isHardLimits = hardLimits;
    }
}

