/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.payload;

import com.ur.polyscope.internaltcp.impl.payload.InstallationPayloadConstraint;
import com.ur.swing.validation.ValidationStrategy;
import java.util.Set;
import javax.inject.Inject;

public class PayloadWarningValidationStrategy
implements ValidationStrategy {
    private String lastErrorMessage;
    private Set<InstallationPayloadConstraint> constraints;
    private boolean isHardLimits;

    @Inject
    public PayloadWarningValidationStrategy(Set<InstallationPayloadConstraint> constraints) {
        this.constraints = constraints;
    }

    public boolean isValid(String payload) {
        this.lastErrorMessage = "";
        for (InstallationPayloadConstraint constraint : this.constraints) {
            constraint.setIsHardLimit(this.isHardLimits);
            if (constraint.isValid(payload)) continue;
            this.lastErrorMessage = constraint.getErrorMessage(payload);
            return false;
        }
        return true;
    }

    public String getErrorMessage(String s) {
        return this.lastErrorMessage;
    }

    public void setHardLimits(boolean hardLimits) {
        this.isHardLimits = hardLimits;
    }
}

