/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.payload.usecases;

import com.ur.polyscope.internaltcp.impl.payload.EmptyPayloadValidationStrategy;
import com.ur.polyscope.internaltcp.impl.payload.MaximumPayloadForRobot;
import com.ur.polyscope.internaltcp.impl.payload.PayloadConstraint;
import com.ur.polyscope.internaltcp.impl.payload.PayloadValidationStrategy;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.PayloadValidation;
import com.ur.swing.validation.ValidationStrategy;
import javax.inject.Inject;
import javax.inject.Provider;

public class PayloadValidationFactory
implements PayloadValidation {
    private final Provider<PayloadValidationStrategy> payloadValidationStrategyProvider;
    private final Provider<EmptyPayloadValidationStrategy> emptyPayloadValidationStrategyProvider;

    @Inject
    public PayloadValidationFactory(Provider<PayloadValidationStrategy> payloadValidationStrategyProvider, Provider<EmptyPayloadValidationStrategy> emptyPayloadValidationStrategyProvider) {
        this.payloadValidationStrategyProvider = payloadValidationStrategyProvider;
        this.emptyPayloadValidationStrategyProvider = emptyPayloadValidationStrategyProvider;
    }

    public AutoCorrectionValidator getPayloadValidator(boolean isHard, boolean isEmptyPayloadValueValid) {
        double min = 0.0;
        double max = 0.0;
        PayloadValidationStrategy payloadValidationStrategy = (PayloadValidationStrategy)this.payloadValidationStrategyProvider.get();
        if (isEmptyPayloadValueValid) {
            payloadValidationStrategy = (PayloadValidationStrategy)this.emptyPayloadValidationStrategyProvider.get();
        }
        payloadValidationStrategy.setHardLimits(isHard);
        PayloadConstraint payloadConstraint = payloadValidationStrategy.getPayloadConstraint();
        if (payloadConstraint instanceof MaximumPayloadForRobot) {
            MaximumPayloadForRobot maximumPayloadForRobot = (MaximumPayloadForRobot)payloadConstraint;
            min = maximumPayloadForRobot.getMinPayload();
            max = maximumPayloadForRobot.getMaxPayloadHardLimit();
        }
        return new AutoCorrectionRangeDecorator((ValidationStrategy)payloadValidationStrategy, min, max);
    }
}

