/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxContentHolder;
import com.ur.polyscope.program.Program;
import com.ur.polyscope.tcp.TCP;
import com.ur.reference.ReferenceService;
import com.ur.swing.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

abstract class TCPSettingManager
implements ActionListener {
    private final InstallationComponentLookup installationLookup;
    private final ReferenceService programReferenceService;
    private final TCPComboBoxContentHolder tcpComboBoxContentHolder;
    private final AbstractButton setTcpCheckBox;
    private final JComboBox tcpComboBox;

    public TCPSettingManager(InstallationComponentLookup installationLookup, @Program ReferenceService programReferenceService, TCPComboBoxContentHolder urCapTCPComboBoxContent, AbstractButton setTcpCheckBox, JComboBox tcpComboBox) {
        this.installationLookup = installationLookup;
        this.programReferenceService = programReferenceService;
        this.tcpComboBoxContentHolder = urCapTCPComboBoxContent;
        this.setTcpCheckBox = setTcpCheckBox;
        this.tcpComboBox = tcpComboBox;
        setTcpCheckBox.addActionListener(this);
        tcpComboBox.setModel(new DefaultComboBoxModel());
        tcpComboBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TCPReference reference = null;
        if (this.setTcpCheckBox.isSelected()) {
            Object selectedItem = this.tcpComboBox.getSelectedItem();
            if (selectedItem instanceof TCP) {
                TCP selectedTCP = (TCP)selectedItem;
                reference = (TCPReference)this.programReferenceService.getReferenceTo(TCPReference.class, (Object)selectedTCP);
            } else if (selectedItem instanceof TCPReference) {
                reference = (TCPReference)((Object)selectedItem);
            } else {
                TCP activeTCP = ((TCPSettings)this.installationLookup.getComponent(TCPSettings.class)).getSelectedTCP_Old();
                reference = (TCPReference)this.programReferenceService.getReferenceTo(TCPReference.class, (Object)activeTCP);
            }
        }
        this.setTcpReference(reference);
    }

    public void setTcpReference(final TCPReference reference) {
        this.setTcpReferenceOnProgramNode(reference);
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (reference == null) {
                    TCPSettingManager.this.setTcpCheckBox.setSelected(false);
                    TCPSettingManager.this.tcpComboBox.setModel(new DefaultComboBoxModel());
                    TCPSettingManager.this.tcpComboBox.setEnabled(false);
                } else {
                    TCPSettingManager.this.setTcpCheckBox.setSelected(true);
                    TCPSettingManager.this.tcpComboBox.setEnabled(true);
                    DefaultComboBoxModel model = TCPSettingManager.this.tcpComboBoxContentHolder.getTcpComboBoxModel();
                    TCPSettingManager.this.tcpComboBox.setModel(model);
                    if (reference.dereference() == null) {
                        model.insertElementAt(reference, 0);
                        TCPSettingManager.this.tcpComboBox.setSelectedItem((Object)reference);
                    } else {
                        TCPSettingManager.this.tcpComboBox.setSelectedItem(reference.dereference());
                    }
                }
            }
        });
    }

    protected abstract void setTcpReferenceOnProgramNode(TCPReference var1);
}

