/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp;

import com.ur.injection.HasKey;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ReferenceOwnerSlice;
import com.ur.polyscope.viewfacade.program.SubstituteReference;
import java.util.Collection;
import javax.inject.Inject;

@HasKey(value="tcp-reference")
public class TcpReferenceComponent
implements DomainComponent,
ReferenceOwnerSlice {
    private final boolean enabled;
    private final TCPReference reference;

    @Inject
    public TcpReferenceComponent() {
        this.enabled = false;
        this.reference = null;
    }

    public TcpReferenceComponent(TCPReference reference) {
        this.enabled = reference != null;
        this.reference = reference;
    }

    public TcpReferenceComponent(boolean isEnabled, TCPReference reference) {
        this.enabled = isEnabled;
        this.reference = reference;
    }

    public TCPReference tcpReference() {
        return this.reference;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDefined() {
        return !this.enabled || this.reference != null && this.reference.dereference() != null;
    }

    public void writeScript(ScriptWriter scriptWriter) {
        if (this.reference != null) {
            scriptWriter.set_tcp(new Pose6d(this.reference.dereference().getOffsetPose().asArray()));
        }
    }

    public String asValue() {
        return null;
    }

    public SubstituteReference substituteReference(Object original, Object substitute) {
        if (this.reference == original && substitute instanceof TCPReference) {
            return SubstituteReference.requestSubstitution((DomainComponent)new TcpReferenceComponent(this.enabled, (TCPReference)((Object)substitute)));
        }
        return SubstituteReference.doNotSubstitute((DomainComponent)this);
    }

    public void collectReferenceEntities(Collection<Object> collection) {
        if (this.reference != null) {
            collection.add((Object)this.reference);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (TcpReferenceComponent.class.equals(obj.getClass())) {
            TcpReferenceComponent other = (TcpReferenceComponent)obj;
            return this.enabled == other.enabled && EqualsUtil.equals((Object)((Object)this.reference), (Object)((Object)other.reference));
        }
        return false;
    }

    public String toString() {
        return "{TCPReferenceComponent: {enabled: " + this.enabled + ", reference: " + (Object)((Object)this.reference) + "}}";
    }
}

