/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.internaltcp.impl.tcp.TCPSettingManager;
import com.ur.polyscope.internaltcp.impl.tcp.TcpReferenceComponent;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxContentHolder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPRenderingStrategy;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.program.Program;
import com.ur.reference.ReferenceService;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.HorizontalLayout;

@HasKey(value="tcp-reference")
public class TcpReferenceView
implements ViewComponent {
    private final TCPSettingManager tcpManager;
    private final JCheckBox setTcpCheckBox;
    private final JComboBox tcpComboBox;
    private final JPanel content;
    private ViewComponent.ModifyListener modifyListener;

    @Inject
    public TcpReferenceView(TextResource textResource, TCPComboBoxContentHolder tcpComboBoxContent, @Program ReferenceService programReferenceService, InstallationComponentLookup installationLookupService) {
        this.setTcpCheckBox = new JCheckBox(textResource.setTCP());
        this.setTcpCheckBox.setFocusable(false);
        this.tcpComboBox = new ComboBox();
        this.setTcpCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tcpComboBox.setPreferredSize(new Dimension(220, 28));
        this.tcpComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer(TCPRenderingStrategy.createWithoutIcon(installationLookupService, null), 400, true));
        this.content = new JPanel((LayoutManager)new HorizontalLayout(12));
        this.content.setBorder(BorderFactory.createEmptyBorder());
        this.content.add(this.setTcpCheckBox);
        this.content.add(this.tcpComboBox);
        RenderingStrategy tcpRenderingStrategy = TCPRenderingStrategy.createWithoutIcon(installationLookupService, null);
        ComboBoxRenderer.bindRenderer((JComboBox)this.tcpComboBox, (RenderingStrategy)tcpRenderingStrategy);
        this.tcpComboBox.setRenderer(new ContributedComboBoxRenderer(tcpRenderingStrategy));
        this.tcpManager = new TCPSettingManager(installationLookupService, programReferenceService, tcpComboBoxContent, this.setTcpCheckBox, this.tcpComboBox){

            @Override
            protected void setTcpReferenceOnProgramNode(TCPReference reference) {
                TcpReferenceView.this.modifyListener.onModified((DomainComponent)new TcpReferenceComponent(TcpReferenceView.this.setTcpCheckBox.isSelected(), reference));
            }
        };
    }

    public JComponent asComponent() {
        return this.content;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domainComponent) {
        TcpReferenceComponent tcpReferenceComponent = (TcpReferenceComponent)domainComponent;
        this.tcpManager.setTcpReference(tcpReferenceComponent.tcpReference());
    }
}

