/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.data;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPFactory;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.tcp.TCPContributorInfoPersister;
import com.ur.polyscope.valueobjects.Weight;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class TCPSettingsConversionStrategy
extends ConversionStrategyTemplate<TCPSettings>
implements InstallationComponentConversionStrategy<TCPSettings> {
    private static final String TCP_SETTINGS = "TCPSettings";
    private static final String ACTIVE_POSE = "activePose";
    private static final String TOOL_PAYLOAD = "toolPayload";
    private static final String CENTER_OF_GRAVITY = "centerOfGravity";
    private static boolean skipPayloadLoadingDuringTest;
    private final TCPContributorInfoPersister tcpContributorInfoPersister;
    private final Provider<TCPSettings> tcpSettingsProvider;
    private final PayloadService payloadService;
    private final TCPFactory tcpFactory;

    @Inject
    public TCPSettingsConversionStrategy(Provider<TCPSettings> tcpSettingsProvider, PayloadService payloadService, TCPFactory tcpFactory, TCPContributorInfoPersister tcpContributorInfoPersister) {
        super(TCPSettings.class);
        this.tcpSettingsProvider = tcpSettingsProvider;
        this.payloadService = payloadService;
        this.tcpFactory = tcpFactory;
        this.tcpContributorInfoPersister = tcpContributorInfoPersister;
    }

    public void marshal(TCPSettings settings, PersistWriter writer) {
        writer.addAttribute(ACTIVE_POSE, ((TCP)settings.getSelectedTCP_Old()).getName());
        writer.startNode("availablePoses");
        for (com.ur.polyscope.tcp.TCP each : settings.getAllTCPs()) {
            writer.startNode("tcp");
            writer.addAttribute("id", ((TCP)each).getId());
            writer.addAttribute("name", ((TCP)each).getName());
            writer.addAttribute("offset", ((TCP)each).getOffset().toArray());
            if (each instanceof TCPContributed) {
                this.tcpContributorInfoPersister.write(writer, ((TCPContributed)each).getContributorInfo());
            }
            writer.endNode();
        }
        writer.endNode();
    }

    public TCPSettings unmarshal(PersistReader reader) {
        TCPSettings settings = (TCPSettings)this.tcpSettingsProvider.get();
        String activeTCP = reader.getStringAttribute(ACTIVE_POSE);
        if (reader.hasOneOfAttributes(new String[]{TOOL_PAYLOAD})) {
            Vector3d cog;
            double payload = reader.getDoubleAttribute(TOOL_PAYLOAD);
            double[] cogData = reader.getDoubleArrayAttribute(CENTER_OF_GRAVITY);
            Vector3d vector3d = cog = cogData == null ? new Vector3d() : new Vector3d(cogData);
            if (!skipPayloadLoadingDuringTest) {
                InstallationPayloadComponent payloadComponent = this.payloadService.addPayloadWithoutDelay("Payload", Weight.from((double)payload, (Weight.Unit)Weight.Unit.SI), cog, new Matrix3d());
                this.payloadService.setInstallationDefaultPayload(payloadComponent);
            }
        }
        reader.moveToChildNode();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            ContributorInfo contributorInfo = null;
            String uuid = reader.getStringAttribute("id");
            String name = reader.getStringAttribute("name");
            Pose6d pose6d = new Pose6d(reader.getDoubleArrayAttribute("offset"));
            if (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                contributorInfo = this.readContributionInfo(reader);
                reader.moveToParentNode();
            }
            if (uuid == null) {
                if (contributorInfo == null) {
                    settings.addTCP(this.tcpFactory.create(name, pose6d));
                } else {
                    settings.addTCP(this.tcpFactory.create(name, pose6d, contributorInfo));
                }
            } else if (contributorInfo == null) {
                settings.addTCP(this.tcpFactory.create(UUID.fromString(uuid), name, pose6d));
            } else {
                settings.addTCP(this.tcpFactory.create(UUID.fromString(uuid), name, pose6d, contributorInfo));
            }
            reader.moveToParentNode();
        }
        reader.moveToParentNode();
        settings.selectTCP(activeTCP);
        return settings;
    }

    private ContributorInfo readContributionInfo(PersistReader reader) {
        if (reader.getNodeName().equals("ContributorInfo")) {
            return this.tcpContributorInfoPersister.read(reader);
        }
        return null;
    }

    public Map<String, Class<? extends TCPSettings>> getClassAliases(boolean forMarshalling) {
        return new LinkedHashMap<String, Class<? extends TCPSettings>>(){
            {
                this.put(TCPSettingsConversionStrategy.TCP_SETTINGS, TCPSettings.class);
                this.put("com.ur.view.tcp.domain.TCPSettingsImpl", TCPSettings.class);
                this.put("com.ur.polyscope.internaltcp.domain.TCPSettingsImpl", TCPSettings.class);
            }
        };
    }

    public Map<String, Class<? extends TCPSettings>> getTypeAliases(boolean forMarshalling) {
        return new HashMap<String, Class<? extends TCPSettings>>(){
            {
                this.put(TCPSettingsConversionStrategy.TCP_SETTINGS, TCPSettings.class);
            }
        };
    }

    public static void setSkipPayloadLoadingDuringTest(boolean value) {
        skipPayloadLoadingDuringTest = value;
    }
}

