/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxModel;
import com.ur.polyscope.tcp.TCP;
import com.ur.swing.renderers.contributed.ContributedHeading;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;

public class TCPComboBoxContentHolder {
    private final InstallationComponentLookup installationLookup;

    @Inject
    public TCPComboBoxContentHolder(InstallationComponentLookup installationLookup) {
        this.installationLookup = installationLookup;
    }

    private Map<ContributedHeading, List<TCPContributed>> getURCapTCPVendorMap() {
        TreeMap<ContributedHeading, List<TCPContributed>> urCapTcpVendorMap = new TreeMap<ContributedHeading, List<TCPContributed>>();
        List<TCPContributed> urCapDefinedTCPs = ((TCPSettings)this.installationLookup.getComponent(TCPSettings.class)).getContributedTCPs();
        for (TCPContributed tcpContributed : urCapDefinedTCPs) {
            ContributedHeading urCapHeading = new ContributedHeading(tcpContributed.getContributorInfo().getOwnerDisplayName());
            ArrayList<TCPContributed> tcps = (ArrayList<TCPContributed>)urCapTcpVendorMap.get(urCapHeading);
            if (tcps == null) {
                tcps = new ArrayList<TCPContributed>();
            }
            tcps.add(tcpContributed);
            urCapTcpVendorMap.put(urCapHeading, tcps);
        }
        return urCapTcpVendorMap;
    }

    private void setURCapTCPComboBoxModel(TCPComboBoxModel model) {
        Map<ContributedHeading, List<TCPContributed>> urCapTCPVendorMap = this.getURCapTCPVendorMap();
        for (Map.Entry<ContributedHeading, List<TCPContributed>> entry : urCapTCPVendorMap.entrySet()) {
            model.addElement(entry.getKey());
            for (TCPContributed tcpContributed : entry.getValue()) {
                model.addElement(tcpContributed);
            }
        }
    }

    private void setUserDefinedTCPComboBoxModel(TCPComboBoxModel model) {
        List<TCP> userDefinedTCPs = ((TCPSettings)this.installationLookup.getComponent(TCPSettings.class)).getUserDefinedTCPs();
        for (TCP tcp : userDefinedTCPs) {
            model.addElement(tcp);
        }
    }

    public DefaultComboBoxModel getTcpComboBoxModel() {
        TCPComboBoxModel model = new TCPComboBoxModel();
        this.setUserDefinedTCPComboBoxModel(model);
        this.setURCapTCPComboBoxModel(model);
        return model;
    }
}

