/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxContentHolder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPNumberFieldBinder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPRenderingStrategy;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachCallback;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachOrientationPanel;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPanelBase;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPositionPanel;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.UpdatePoseOnComplete;
import com.ur.polyscope.internaltcp.impl.tcp.usecases.RequestUpdateOfComponents;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.PopupMenuListener;
import javax.vecmath.Vector3d;

public abstract class TCPConfigurationTab
extends CardPanel
implements TCPTeachCallback,
RequestUpdateOfComponents {
    public static final String TEACH_POSITION = "TEACH_POSITION." + TCPConfigurationTab.class.getSimpleName();
    public static final String TEACH_ORIENTATION = "TEACH_ORIENTATION." + TCPConfigurationTab.class.getSimpleName();
    public static final String ADD_TCP = "ADD_TCP." + TCPConfigurationTab.class.getSimpleName();
    public static final String REMOVE_TCP = "REMOVE_TCP." + TCPConfigurationTab.class.getSimpleName();
    public static final String APPLY_SELECTED_TCP = "APPLY_SELECTED_TCP." + TCPConfigurationTab.class.getSimpleName();
    public static final String AVAILABLE_TCPS = "AVAILABLE_TCPS." + TCPConfigurationTab.class.getSimpleName();
    public static final String SHOW_TCP_CONFIGURATION_ACTION = "showTCPConfigurationAction." + TCPConfigurationTab.class.getSimpleName();
    public static final String X_AXIS = "X_AXIS." + TCPConfigurationTab.class.getSimpleName();
    public static final String Y_AXIS = "Y_AXIS." + TCPConfigurationTab.class.getSimpleName();
    public static final String Z_AXIS = "Z_AXIS." + TCPConfigurationTab.class.getSimpleName();
    public static final String ROTATION_X = "ROTATION_X." + TCPConfigurationTab.class.getSimpleName();
    public static final String ROTATION_Y = "ROTATION_Y." + TCPConfigurationTab.class.getSimpleName();
    public static final String ROTATION_Z = "ROTATION_Z." + TCPConfigurationTab.class.getSimpleName();
    public static final String TOOL_PAYLOAD = "TOOL_PAYLOAD." + TCPConfigurationTab.class.getSimpleName();
    static final String RENAME_TCP = "RENAME_TCP." + TCPConfigurationTab.class.getSimpleName();
    static final String ILLUSTRATION_CARD = "illustration";
    private static final UnitsConverter COORDINATE_CONVERTER = Units.getMetersConverter();
    protected final InstallationComponentLookup installationLookupService;
    protected final TextResource textResource;
    protected final ViewContext viewContext;
    protected final HelpIdAssigner helpIdAssigner;
    private final TCPComboBoxContentHolder tcpComboBoxContentHolder;
    private final TCPNumberFieldBinder numberFieldBinder;
    private final NamingService namingService;
    protected JButton addTCP;
    protected JButton renameTCP;
    protected JButton removeTCP;
    protected JButton applySelectedTCP;
    protected JComboBox tcpComboBox;
    protected JPanel illustrationAndTeachTCPPanel;
    protected NumberField positionX;
    protected NumberField positionY;
    protected NumberField positionZ;
    protected NumberField rotationX;
    protected NumberField rotationY;
    protected NumberField rotationZ;
    protected JPanel settingsPanel;
    protected JButton teachOrientation;
    protected JButton teachPosition;
    protected TCPTeachOrientationPanel teachOrientationPanel;
    protected TCPTeachPositionPanel teachPositionPanel;
    Collection<TCPTeachPanelBase> teachPanels = new HashSet<TCPTeachPanelBase>();
    private TCP tcpBeingTaught;

    @Inject
    public TCPConfigurationTab(InstallationComponentLookup installationLookupService, ViewContext viewContext, TCPComboBoxContentHolder tcpComboBoxContentHolder, TCPNumberFieldBinder numberFieldBinder, NamingService namingService) {
        this.installationLookupService = installationLookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.viewContext = viewContext;
        this.tcpComboBoxContentHolder = tcpComboBoxContentHolder;
        this.numberFieldBinder = numberFieldBinder;
        this.namingService = namingService;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
    }

    protected CompletedListener createCompletedListener() {
        return new UpdatePoseOnComplete(this, this.installationLookupService, this.tcpComboBox, null, new JTextField[]{this.positionX, this.positionY, this.positionZ, this.rotationX, this.rotationY, this.rotationZ});
    }

    protected void bindComponents() {
        final CompletedListener listener = this.createCompletedListener();
        ActionListener applyRequest = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.requestApply();
            }
        };
        this.numberFieldBinder.bindAxis(this.positionX, applyRequest, 10.0, X_AXIS);
        this.numberFieldBinder.bindAxis(this.positionY, applyRequest, 10.0, Y_AXIS);
        this.numberFieldBinder.bindAxis(this.positionZ, applyRequest, 10.0, Z_AXIS);
        this.numberFieldBinder.bindRotation(this.rotationX, applyRequest, ROTATION_X);
        this.numberFieldBinder.bindRotation(this.rotationY, applyRequest, ROTATION_Y);
        this.numberFieldBinder.bindRotation(this.rotationZ, applyRequest, ROTATION_Z);
        TCPRenderingStrategy tcpRenderingStrategy = new TCPRenderingStrategy(this.installationLookupService, (TextResource)this.viewContext.getTextResource(TextResource.class), true);
        TCPSettings tcpSettings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        this.tcpComboBox.setSelectedItem(tcpSettings.getSelectedTCP_Old());
        this.tcpComboBox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)tcpRenderingStrategy));
        this.tcpComboBox.setModel(this.getTCPComboBoxModel());
        this.tcpComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)tcpRenderingStrategy, 700));
        this.tcpComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TCPConfigurationTab.this.updatePoseInTextFields();
            }
        });
        this.addTCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                com.ur.polyscope.tcp.TCP newTCP = ((TCPSettings)TCPConfigurationTab.this.installationLookupService.getComponent(TCPSettings.class)).addNewTCP();
                TCPConfigurationTab.this.tcpComboBox.setModel(TCPConfigurationTab.this.getTCPComboBoxModel());
                TCPConfigurationTab.this.tcpComboBox.setSelectedItem(newTCP);
                TCPConfigurationTab.this.updateComponents();
            }
        });
        this.setupRename();
        this.removeTCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TCP tcp = (TCP)TCPConfigurationTab.this.tcpComboBox.getSelectedItem();
                MutableComboBoxModel model = (MutableComboBoxModel)TCPConfigurationTab.this.tcpComboBox.getModel();
                TCPSettings tcpSettings = (TCPSettings)TCPConfigurationTab.this.installationLookupService.getComponent(TCPSettings.class);
                boolean setActive = tcp == tcpSettings.getSelectedTCP_Old();
                tcpSettings.removeTCP(tcp);
                model.removeElement(tcp);
                if (setActive) {
                    model.setSelectedItem(tcpSettings.getSelectedTCP_Old());
                }
                TCPConfigurationTab.this.updateComponents();
            }
        });
        this.applySelectedTCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TCP selectedItem = (TCP)TCPConfigurationTab.this.tcpComboBox.getSelectedItem();
                try {
                    TCPSettings tcpSettings = (TCPSettings)TCPConfigurationTab.this.installationLookupService.getComponent(TCPSettings.class);
                    tcpSettings.selectTCP(selectedItem.getName());
                    TCPConfigurationTab.this.tcpComboBox.repaint();
                }
                catch (Exception exception) {
                    Log.error((String)"Write failed in TCPPositionTab:tcpUpdate");
                }
                TCPConfigurationTab.this.updateComponents();
            }
        });
    }

    protected void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.tcpComboBox, "gui:installation_tcp_position");
        this.helpIdAssigner.assignHelpId((JComponent)this.positionX, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.positionY, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.positionZ, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.rotationX, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.rotationY, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.rotationZ, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.addTCP, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.removeTCP, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.renameTCP, "gui:installation:tcp:modifying_adding_removing");
        this.helpIdAssigner.assignHelpId((JComponent)this.applySelectedTCP, "gui:installation:tcp:default");
        this.helpIdAssigner.assignHelpId((JComponent)this.teachPosition, "gui:installation:tcp:teaching_position");
        this.helpIdAssigner.assignHelpId((JComponent)this.teachPositionPanel, "gui:installation:tcp:teaching_position");
        this.helpIdAssigner.assignHelpId((JComponent)this.teachOrientation, "gui:installation:tcp:teaching_orientation");
        this.helpIdAssigner.assignHelpId((JComponent)this.teachOrientationPanel, "gui:installation:tcp:teaching_orientation");
    }

    public void enter(Object o) {
        super.enter(o);
        boolean disableTeaching = o != null && o.equals(true);
        this.teachPosition.setVisible(!disableTeaching);
        this.teachOrientation.setVisible(!disableTeaching);
        for (TCPTeachPanelBase panelBase : this.teachPanels) {
            try {
                panelBase.enter();
            }
            catch (NullPointerException nullPointerException) {}
        }
        TCPSettings tcpSettings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        this.tcpComboBox.setModel(this.getTCPComboBoxModel());
        this.tcpComboBox.setSelectedItem(this.isTeaching() ? this.tcpBeingTaught : tcpSettings.getSelectedTCP_Old());
        this.updateComponents();
    }

    private DefaultComboBoxModel getTCPComboBoxModel() {
        return this.tcpComboBoxContentHolder.getTcpComboBoxModel();
    }

    private ValidationStrategy getTCPNameValidationStrategy() {
        return new ValidationStrategy(){

            public boolean isValid(String name) {
                String oldName = "";
                Object selectedItem = TCPConfigurationTab.this.tcpComboBox.getModel().getSelectedItem();
                if (selectedItem instanceof TCP) {
                    oldName = ((TCP)selectedItem).getName();
                }
                return TCPConfigurationTab.this.namingService.isNameValid(TCP.class, name) && !TCPConfigurationTab.this.namingService.isNameUsed(TCP.class, name) && !TCPConfigurationTab.this.namingService.isReservedName(name) || name.equals(oldName);
            }

            public String getErrorMessage(String name) {
                if (name.length() == 0) {
                    return "";
                }
                int maximumLength = TCPConfigurationTab.this.namingService.maxNameLength(TCP.class);
                if (name.length() > maximumLength) {
                    return TCPConfigurationTab.this.textResource.maximumTextLength(maximumLength);
                }
                if (!TCPConfigurationTab.this.namingService.isNameValid(TCP.class, name) || TCPConfigurationTab.this.namingService.isReservedName(name)) {
                    return TCPConfigurationTab.this.textResource.illegalName();
                }
                if (TCPConfigurationTab.this.namingService.isNameUsed(TCP.class, name)) {
                    return TCPConfigurationTab.this.textResource.nameIsAlreadyUsed();
                }
                return TCPConfigurationTab.this.textResource.illegalName();
            }
        };
    }

    private void setupRename() {
        TextHolder provider = this.createTextHolder();
        TextFieldUtils.bindTextPicker((JComponent)this.renameTCP, (TextHolder)provider, (ValidationStrategy)this.getTCPNameValidationStrategy());
    }

    TextHolder createTextHolder() {
        return new TextHolder(){

            public String getText() {
                Object selectedItem = TCPConfigurationTab.this.tcpComboBox.getSelectedItem();
                if (selectedItem instanceof TCP) {
                    return ((TCP)selectedItem).getName();
                }
                return "";
            }

            public void setText(String text) {
                TCPSettings tcpSettings = (TCPSettings)TCPConfigurationTab.this.installationLookupService.getComponent(TCPSettings.class);
                com.ur.polyscope.tcp.TCP selectedTCP = tcpSettings.getSelectedTCP_Old();
                Object selectedItem = TCPConfigurationTab.this.tcpComboBox.getModel().getSelectedItem();
                if (selectedItem instanceof TCP) {
                    TCP tcp = (TCP)selectedItem;
                    tcp.setName(text);
                    if (selectedTCP == selectedItem) {
                        tcpSettings.selectTCP(text);
                    }
                    TCPConfigurationTab.this.updateComponents();
                }
            }
        };
    }

    @Override
    public void updateComponents() {
        CardLayout cardLayout = (CardLayout)this.illustrationAndTeachTCPPanel.getLayout();
        this.setEnabled(this.settingsPanel, !this.isTeaching());
        String cardToShow = ILLUSTRATION_CARD;
        for (TCPTeachPanelBase teachPanel : this.teachPanels) {
            if (!teachPanel.isActive()) continue;
            cardToShow = teachPanel.getClass().getName();
            break;
        }
        cardLayout.show(this.illustrationAndTeachTCPPanel, cardToShow);
        this.updatePoseInTextFields();
    }

    @Override
    public void setPositionOffset(Vector3d calculatedOffset) {
        Pose6d offset = this.tcpBeingTaught.getOffset();
        offset.setPos(new Vector3d(calculatedOffset));
        this.tcpBeingTaught.setOffset(offset);
        this.applyTCPIfDefault(this.tcpBeingTaught);
        this.updateComponents();
    }

    @Override
    public void setOrientationOffset(Vector3d calculatedOffset) {
        Pose6d offset = this.tcpBeingTaught.getOffset();
        offset.setRot(new Vector3d(calculatedOffset));
        this.tcpBeingTaught.setOffset(offset);
        this.applyTCPIfDefault(this.tcpBeingTaught);
        this.updateComponents();
    }

    private void applyTCPIfDefault(TCP newTCP) {
        TCPSettings tcpSettings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        String newTCPName = newTCP.getName();
        if (EqualsUtil.equals((Object)newTCPName, (Object)((TCP)tcpSettings.getSelectedTCP_Old()).getName())) {
            tcpSettings.selectTCP(newTCPName);
        }
    }

    protected boolean isTeaching() {
        for (TCPTeachPanelBase panelBase : this.teachPanels) {
            if (!panelBase.isActive()) continue;
            return true;
        }
        return false;
    }

    void updatePoseInTextFields() {
        TCP selectedTCP = this.getSelectedTCP();
        if (selectedTCP != null) {
            boolean editable = this.isPoseInEditable(selectedTCP);
            this.teachPosition.setEnabled(editable);
            this.teachOrientation.setEnabled(editable);
            this.applySelectedTCP.setEnabled(this.isApplySelectedTCPEnabled());
            this.renameTCP.setEnabled(editable);
            this.removeTCP.setEnabled(!this.isTeaching() && this.isSelectedTcpRemoveable());
            Pose6d selectedPose = selectedTCP.getOffset();
            this.updatePositionPoseInTextFields(selectedPose, editable);
            this.updateRotationPoseInTextFields(selectedPose, editable);
        }
    }

    protected TCP getSelectedTCP() {
        return (TCP)this.tcpComboBox.getSelectedItem();
    }

    private void updatePositionPoseInTextFields(Pose6d selectedPose, boolean editable) {
        this.positionX.setText("" + COORDINATE_CONVERTER.convertFrom(selectedPose.getX()));
        this.positionY.setText("" + COORDINATE_CONVERTER.convertFrom(selectedPose.getY()));
        this.positionZ.setText("" + COORDINATE_CONVERTER.convertFrom(selectedPose.getZ()));
        this.setEnabled(this.positionX, editable);
        this.setEnabled(this.positionY, editable);
        this.setEnabled(this.positionZ, editable);
    }

    protected void updateRotationPoseInTextFields(Pose6d selectedPose, boolean editable) {
        this.setEnabled(this.rotationX, editable);
        this.setEnabled(this.rotationY, editable);
        this.setEnabled(this.rotationZ, editable);
    }

    private void setEnabled(NumberField numberField, boolean enabled) {
        numberField.setEnabled(enabled);
        numberField.setBorderEnabled(enabled);
    }

    private boolean isPoseInEditable(TCP selectedTCP) {
        boolean contributedTCP = this.isContributedTCP(selectedTCP);
        boolean teaching = this.isTeaching();
        return !contributedTCP && !teaching;
    }

    protected boolean isContributedTCP(TCP tcp) {
        return tcp instanceof TCPContributed;
    }

    private boolean isSelectedTcpRemoveable() {
        TCP selectedTcp = (TCP)this.tcpComboBox.getSelectedItem();
        TCPSettings tcpSettings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        return !this.isContributedTCP(selectedTcp) && tcpSettings.getUserDefinedTCPs().size() > 1;
    }

    boolean isApplySelectedTCPEnabled() {
        com.ur.polyscope.tcp.TCP defaultTCP;
        TCP selectedTCP = (TCP)this.tcpComboBox.getSelectedItem();
        return selectedTCP != (defaultTCP = ((TCPSettings)this.installationLookupService.getComponent(TCPSettings.class)).getSelectedTCP_Old());
    }

    protected abstract void initComponents();

    void teachActionPerformed(TCPTeachPanelBase panelBase) {
        this.tcpBeingTaught = (TCP)this.tcpComboBox.getSelectedItem();
        panelBase.setActive(true);
        this.updateComponents();
    }

    void teachPositionActionPerformed() {
        this.teachActionPerformed(this.teachPositionPanel);
    }

    void teachOrientationActionPerformed() {
        this.teachActionPerformed(this.teachOrientationPanel);
    }

    private void setEnabled(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                this.setEnabled(child, enabled);
                ++n2;
            }
        }
    }

    @Override
    public void teachComplete() {
        this.updateComponents();
    }

    @Override
    public CardPanel getTeachCallbackCardPanel() {
        return this;
    }

    JButton getAddTCP() {
        return this.addTCP;
    }

    JButton getRemoveTCP() {
        return this.removeTCP;
    }

    JComboBox getTcpComboBox() {
        return this.tcpComboBox;
    }

    NumberField getPositionX() {
        return this.positionX;
    }

    NumberField getPositionY() {
        return this.positionY;
    }

    NumberField getPositionZ() {
        return this.positionZ;
    }

    NumberField getRotationX() {
        return this.rotationX;
    }

    NumberField getRotationY() {
        return this.rotationY;
    }

    NumberField getRotationZ() {
        return this.rotationZ;
    }

    JButton getApplySelectedTCP() {
        return this.applySelectedTCP;
    }
}

