/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxContentHolder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPConfigurationTab;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPIllustrationPanel;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPNumberFieldBinder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachOrientationPanel;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPanelBase;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPositionPanel;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.UpdatePoseOnComplete;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentationFactory;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberFieldBorderable;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.vecmath.Vector3d;

public class TCPConfigurationTabImpl
extends TCPConfigurationTab {
    private final PoweredOnRobotRequirement poweredOnRobotRequirement;
    private final EventManager eventManager;
    private JComboBox rotationTypeComboBox;
    private List<RotationRepresentation> rotationRepresentationList;
    private final TCPIllustrationPanel tcpIllustrationPanel;
    private PositionRequester positionRequester;
    private final FeatureService featureService;
    private RotationRepresentation rotationRepresentation;
    private InstallationStateListener refreshOnInstallationLoad = new RefreshOnInstallationLoaded();
    private Subscription refreshOnInstallationLoadSub = Subscription.NULL;
    private static final DecimalFormat degFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    private static final DecimalFormat rotationFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0000");

    @Inject
    public TCPConfigurationTabImpl(InstallationComponentLookup installationLookupService, ViewContext viewContext, PoweredOnRobotRequirement poweredOnRobotRequirement, TCPNumberFieldBinder numberFieldBinder, NamingService namingService, TCPComboBoxContentHolder tcpComboBoxContent, TCPIllustrationPanel tcpIllustrationPanel, PositionRequester positionRequester, FeatureService featureService, EventManager eventManager) {
        super(installationLookupService, viewContext, tcpComboBoxContent, numberFieldBinder, namingService);
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.rotationRepresentationList = RotationRepresentationFactory.createAll();
        this.tcpIllustrationPanel = tcpIllustrationPanel;
        this.positionRequester = positionRequester;
        this.featureService = featureService;
        this.eventManager = eventManager;
        this.rotationRepresentation = this.rotationRepresentationList.get(0);
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)((Object)new UpdateOnInstallationLoaded()));
        this.initComponents();
        this.bindComponents();
        this.initHelpIds();
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        this.refreshOnInstallationLoadSub.dispose();
        this.refreshOnInstallationLoadSub = this.eventManager.addStrongListener(InstallationStateListener.class, (Object)this.refreshOnInstallationLoad);
        if (!this.isTeaching()) {
            this.tcpIllustrationPanel.enter(o);
        }
    }

    public Object exit() {
        if (!this.isTeaching()) {
            this.tcpIllustrationPanel.exit();
        }
        this.refreshOnInstallationLoadSub.dispose();
        this.refreshOnInstallationLoadSub = Subscription.NULL;
        return super.exit();
    }

    @Override
    protected CompletedListener createCompletedListener() {
        return new UpdatePoseOnComplete(this, this.installationLookupService, this.tcpComboBox, this.rotationTypeComboBox, new JTextField[]{this.positionX, this.positionY, this.positionZ, this.rotationX, this.rotationY, this.rotationZ});
    }

    @Override
    protected void initHelpIds() {
        super.initHelpIds();
    }

    @Override
    protected void initComponents() {
        this.initSettingsPanel();
        this.initIllustrationAndTeachTCPPanel();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add(this.settingsPanel, "Center");
        this.add(this.illustrationAndTeachTCPPanel, "East");
    }

    @Override
    protected void bindComponents() {
        super.bindComponents();
        this.tcpComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TCPConfigurationTabImpl.this.tcpIllustrationPanel.setSelectedTcp(TCPConfigurationTabImpl.this.getSelectedTCP());
            }
        });
    }

    @Override
    public void updateComponents() {
        super.updateComponents();
        this.applySelectedTCP.setEnabled(this.isApplySelectedTCPEnabled());
    }

    @Override
    protected void updateRotationPoseInTextFields(Pose6d selectedPose, boolean editable) {
        super.updateRotationPoseInTextFields(selectedPose, editable);
        Vector3d rotation = this.rotationRepresentation.computeRotation(selectedPose.getRot());
        this.rotationRepresentation.setValues(rotation);
        this.setToolPositionValueTextFields(selectedPose);
    }

    private void initializeRotationTypeComboBox() {
        DefaultComboBoxModel<RotationRepresentation> comboBoxModel = new DefaultComboBoxModel<RotationRepresentation>();
        for (RotationRepresentation rr : this.rotationRepresentationList) {
            comboBoxModel.addElement(rr);
        }
        this.rotationTypeComboBox.setModel(comboBoxModel);
    }

    private void rotationTypeComboBoxActionPerformed() {
        try {
            RotationRepresentation newSelectedRotationRepresentation = (RotationRepresentation)this.rotationTypeComboBox.getSelectedItem();
            Vector3d rotation = newSelectedRotationRepresentation.computeRotation(this.rotationRepresentation.getRotationMatrix());
            newSelectedRotationRepresentation.setValues(rotation);
            this.rotationRepresentation = newSelectedRotationRepresentation;
            this.setToolRotationValueTextFields(rotation);
        }
        catch (Exception e) {
            Log.error((String)"Something that was not a RotationRepresentation was in the rotationTypeComboBox: ", (Throwable)e);
        }
    }

    private void setToolPositionValueTextFields(Pose6d toolFeaturePose) {
        this.rotationRepresentation.setAllowConversion(false);
        Vector3d rotation = this.rotationRepresentation.computeRotation(toolFeaturePose.getRot());
        this.rotationRepresentation.setValues(this.rotationRepresentation.computeRotation(this.rotationRepresentation.getRotationMatrix(rotation)));
        this.setToolRotationValueTextFields(this.rotationRepresentation.getValues());
    }

    private void setToolRotationValueTextFields(Vector3d rotation) {
        if (this.rotationRepresentation.getRotationType() == RotationRepresentation.RotationType.ANGLES_DEGREES || this.rotationRepresentation.getRotationType() == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            this.rotationX.setText(degFormat.format(rotation.x));
            this.rotationY.setText(degFormat.format(rotation.y));
            this.rotationZ.setText(degFormat.format(rotation.z));
        } else {
            this.rotationX.setText(rotationFormat.format(rotation.x));
            this.rotationY.setText(rotationFormat.format(rotation.y));
            this.rotationZ.setText(rotationFormat.format(rotation.z));
        }
    }

    private void initSettingsPanel() {
        JPanel tcpPanel = this.createTCPPanel();
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BorderLayout(5, 5));
        this.settingsPanel.add((Component)tcpPanel, "Center");
        this.settingsPanel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
    }

    private void initIllustrationAndTeachTCPPanel() {
        this.teachPositionPanel = new TCPTeachPositionPanel(this, this.textResource, this.positionRequester);
        this.teachPanels.add(this.teachPositionPanel);
        this.teachOrientationPanel = new TCPTeachOrientationPanel(this, this.textResource, this.positionRequester, this.featureService);
        this.teachPanels.add(this.teachOrientationPanel);
        this.illustrationAndTeachTCPPanel = new JPanel(new CardLayout());
        this.illustrationAndTeachTCPPanel.setPreferredSize(new Dimension(575, 655));
        this.illustrationAndTeachTCPPanel.add((Component)this.tcpIllustrationPanel, "illustration");
        this.illustrationAndTeachTCPPanel.add((Component)this.teachPositionPanel, this.teachPositionPanel.getClass().getName());
        this.illustrationAndTeachTCPPanel.add((Component)this.teachOrientationPanel, this.teachOrientationPanel.getClass().getName());
    }

    private JPanel createTCPPanel() {
        this.addTCP = new JButton(TcpImageResource.plusIcon());
        this.addTCP.setName(TCPConfigurationTab.ADD_TCP);
        this.addTCP.setPreferredSize(new Dimension(50, 32));
        this.addTCP.setFocusable(false);
        this.renameTCP = new JButton(TcpImageResource.rename());
        this.renameTCP.setName(TCPConfigurationTab.RENAME_TCP);
        this.renameTCP.setPreferredSize(new Dimension(50, 32));
        this.renameTCP.setFocusable(false);
        this.removeTCP = new JButton(TcpImageResource.delete());
        this.removeTCP.setName(TCPConfigurationTab.REMOVE_TCP);
        this.removeTCP.setPreferredSize(new Dimension(50, 32));
        this.removeTCP.setFocusable(false);
        this.positionX = new NumberField(UnitsValueConverterFactory.getLengthConverter());
        this.positionY = new NumberField(UnitsValueConverterFactory.getLengthConverter());
        this.positionZ = new NumberField(UnitsValueConverterFactory.getLengthConverter());
        this.rotationX = new NumberField(NumberFieldBorderable.DUMMY_CONVERTER);
        this.rotationY = new NumberField(NumberFieldBorderable.DUMMY_CONVERTER);
        this.rotationZ = new NumberField(NumberFieldBorderable.DUMMY_CONVERTER);
        this.teachPosition = new JButton(HTML.html((String)this.textResource.measure()), TcpImageResource.wizardIcon());
        this.teachPosition.setName(TCPConfigurationTab.TEACH_POSITION);
        this.teachPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TCPConfigurationTabImpl.this.poweredOnRobotRequirement.checkAndNotify()) {
                    TCPConfigurationTabImpl.this.teachPositionActionPerformed();
                }
            }
        });
        this.teachOrientation = new JButton(HTML.html((String)this.textResource.measure()), TcpImageResource.wizardIcon());
        this.teachOrientation.setName(TCPConfigurationTab.TEACH_ORIENTATION);
        this.teachOrientation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TCPConfigurationTabImpl.this.poweredOnRobotRequirement.checkAndNotify()) {
                    TCPConfigurationTabImpl.this.teachOrientationActionPerformed();
                }
            }
        });
        this.applySelectedTCP = new JButton(TcpImageResource.defaultIcon());
        this.applySelectedTCP.setName(TCPConfigurationTab.APPLY_SELECTED_TCP);
        this.applySelectedTCP.setPreferredSize(new Dimension(50, 32));
        this.applySelectedTCP.setFocusable(false);
        this.applySelectedTCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TCP selectedTCP = (TCP)TCPConfigurationTabImpl.this.tcpComboBox.getSelectedItem();
                DisplayMessageFactory.inform((JComponent)TCPConfigurationTabImpl.this.applySelectedTCP, (String)TCPConfigurationTabImpl.this.textResource.tcpIsSetAsDefault(selectedTCP.getName()));
                TCPConfigurationTabImpl.this.applySelectedTCP.setEnabled(false);
            }
        });
        this.tcpComboBox = new JComboBox();
        this.tcpComboBox.setName(TCPConfigurationTab.AVAILABLE_TCPS);
        this.tcpComboBox.setPreferredSize(new Dimension(180, 32));
        this.tcpComboBox.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15), this.tcpComboBox.getBorder()));
        this.tcpComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TCPConfigurationTabImpl.this.applySelectedTCP.setEnabled(TCPConfigurationTabImpl.this.isApplySelectedTCPEnabled());
            }
        });
        this.rotationTypeComboBox = new JComboBox();
        this.initializeRotationTypeComboBox();
        this.rotationTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCPConfigurationTabImpl.this.rotationTypeComboBoxActionPerformed();
            }
        });
        return this.formBuildTCPNoPayloadPanel();
    }

    private JPanel formBuildTCPNoPayloadPanel() {
        return this.viewContext.createFormBuilder().component((JComponent)this.renameTCP, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)this.tcpComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).spacer().component((JComponent)this.applySelectedTCP, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addTCP, new FormBuilder.PanelConstraints[0]).component((JComponent)this.removeTCP, new FormBuilder.PanelConstraints[0]).end().end().label(this.boldAndHtml(this.textResource.Position()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label("X", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.positionX, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).spacer().component((JComponent)this.teachPosition, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().label("Y", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.positionY, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().label("Z", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.positionZ, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().end().end().label(this.boldAndHtml(this.textResource.Orientation()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(this.textResource.units(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.rotationTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS}).end().end().label("RX", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.rotationX, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).spacer().component((JComponent)this.teachOrientation, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().label("RY", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.rotationY, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().label("RZ", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.rotationZ, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().groupColumns(new int[]{1, 3, 9, 11, 12}).getCardPanel(this.textResource.toolCenterPoint());
    }

    private String boldAndHtml(String input) {
        return HTML.html((String)("<b>" + input + "</b>"));
    }

    @Override
    void teachActionPerformed(TCPTeachPanelBase panelBase) {
        this.tcpIllustrationPanel.exit();
        super.teachActionPerformed(panelBase);
    }

    @Override
    public void teachComplete() {
        this.tcpIllustrationPanel.enter(null);
        super.teachComplete();
    }

    private class RefreshOnInstallationLoaded
    extends InstallationStateListener.Template {
        private RefreshOnInstallationLoaded() {
        }

        public void installationLoaded(Installation installation) {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TCPConfigurationTabImpl.this.exit();
                    TCPConfigurationTabImpl.this.enter(null);
                }
            });
        }
    }

    private class UpdateOnInstallationLoaded
    extends InstallationStateListener.Template {
        private UpdateOnInstallationLoaded() {
        }

        public void installationLoaded(Installation installation) {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TCPConfigurationTabImpl.this.updateComponents();
                }
            });
        }
    }
}

