/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPVisualization;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.Collections;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TCPIllustrationPanel
extends JPanel
implements EnterExitCard {
    private final TextResource textResource;
    private VisualizerFactory visualizerFactory;
    private Recipe<Arm> armRecipe;
    private HelpIdAssigner helpIdAssigner;
    private JPanel imagePanel;
    private JPanel robotPanel;
    private Component robotView3DPanel;
    private TCPVisualization tcpVisualization;
    private Subscription armSubscription = Subscription.NULL;
    private TCP selectedTcp;

    TCPIllustrationPanel() {
        this.textResource = null;
    }

    @Inject
    public TCPIllustrationPanel(ViewContext viewContext, VisualizerFactory visualizerFactory, @Source(value=Arm.class) Recipe<Arm> armRecipe) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.visualizerFactory = visualizerFactory;
        this.tcpVisualization = new TCPVisualization();
        this.tcpVisualization.setPosition(new Pose6d(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        this.armRecipe = armRecipe;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.initComponents();
        this.initHelpIds();
    }

    protected final void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.imagePanel, "gui:installation_tcp_position");
    }

    private void initComponents() {
        this.initImagePanel();
        this.initRobotView3DPanel();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add((Component)this.robotPanel, "Center");
        this.add((Component)this.imagePanel, "South");
    }

    private void initRobotView3DPanel() {
        this.robotView3DPanel = this.visualizerFactory.createCanvas();
        this.visualizerFactory.setDebugName(this.robotView3DPanel, "G5 TCP 3D Canvas");
        ((RobotCanvas3D)this.robotView3DPanel).showDynamicElements(Collections.singleton(this.tcpVisualization));
        this.robotView3DPanel.setVisible(false);
        this.robotPanel = new JPanel(new BorderLayout());
        this.robotPanel.setBorder((Border)new CardBorder(this.textResource.tcpVisualization()));
        this.robotPanel.add(this.robotView3DPanel, "Center");
    }

    private void initImagePanel() {
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(this.getScaledImage());
        iconLabel.setHorizontalAlignment(0);
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.setBorder(new CompoundBorder((Border)new CardBorder(this.textResource.toolflange()), new EmptyBorder(0, 0, 5, 0)));
        this.imagePanel.add((Component)iconLabel, "Center");
    }

    private ImageIcon getScaledImage() {
        ImageIcon imageIcon = (ImageIcon)TcpImageResource.toolAxisIllustrationSmall();
        double height = 187.0;
        double scaleFactor = height / (double)imageIcon.getIconHeight();
        double scaledHeight = (double)imageIcon.getIconHeight() * scaleFactor;
        double scaledWidth = (double)imageIcon.getIconWidth() * scaleFactor;
        Image scaledImage = imageIcon.getImage().getScaledInstance((int)scaledWidth, (int)scaledHeight, 4);
        return new ImageIcon(scaledImage);
    }

    public void enter(Object o) {
        this.visualizerFactory.showZoomControls(this.robotView3DPanel, true);
        this.robotView3DPanel.setVisible(true);
        this.armSubscription.dispose();
        this.armSubscription = this.armRecipe.executeOnUIThread().subscribe((Consumer)new ArmConsumer());
        ((RobotCanvas3D)this.robotView3DPanel).enter();
    }

    public Object exit() {
        this.armSubscription.dispose();
        this.armSubscription = Subscription.NULL;
        this.robotView3DPanel.setVisible(false);
        ((RobotCanvas3D)this.robotView3DPanel).exit();
        return null;
    }

    public void setSelectedTcp(TCP tcp) {
        this.selectedTcp = tcp;
    }

    private class ArmConsumer
    implements Consumer<Arm> {
        private ArmConsumer() {
        }

        public void accept(Arm arm) {
            TCPIllustrationPanel.this.visualizerFactory.showRobot(TCPIllustrationPanel.this.robotView3DPanel, arm.getActualJointsPosition());
            TCPIllustrationPanel.this.tcpVisualization.setPosition(this.getToolPose(arm, TCPIllustrationPanel.this.selectedTcp));
        }

        private Pose6d getToolPose(Arm arm, TCP tcp) {
            Pose6d toolPose = arm.getTool().getCartesianInfo().getTool();
            if (tcp != null) {
                Pose6d activeTcpOffset = arm.getTool().getCartesianInfo().getTcpOffset();
                Pose6d selectedTcpOffset = tcp.getOffset();
                toolPose = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)toolPose, (Pose6d)activeTcpOffset, (Pose6d)selectedTcpOffset);
            }
            return toolPose;
        }
    }
}

