/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.internaltcp.impl.payload.PayloadValidationStrategy;
import com.ur.polyscope.internaltcp.impl.payload.PayloadWarningValidationStrategy;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPNumberFieldBinder;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;

public class TCPNumberFieldBinderImpl
implements TCPNumberFieldBinder {
    private static final NumberFormat ROTATION_FORMATTER = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0000", (Locale)Locale.ENGLISH);
    private static final int ROTATION_FORMATTER_DECIMAL_PLACES = 4;
    private static final int PAYLOAD_DECIMAL_PLACES = 2;
    private final Provider<PayloadValidationStrategy> payloadValidationStrategyProvider;
    private Provider<PayloadWarningValidationStrategy> payloadWarningValidationStrategyProvider;
    private final TextResource textResource;

    @Inject
    public TCPNumberFieldBinderImpl(Provider<PayloadValidationStrategy> payloadValidationStrategyProvider, Provider<PayloadWarningValidationStrategy> payloadWarningValidationStrategyProvider, ViewContext viewContext) {
        this.payloadValidationStrategyProvider = payloadValidationStrategyProvider;
        this.payloadWarningValidationStrategyProvider = payloadWarningValidationStrategyProvider;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    private boolean isUS() {
        double hack = 1.0;
        return Units.getMmConverter().convertTo(hack) != hack;
    }

    @Override
    public void bindAxis(NumberField axis, ActionListener listener, double hardLimit, String name) {
        DecimalFormat coordinateFormat = this.isUS() ? DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0##", (Locale)Locale.ENGLISH) : DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.0#", (Locale)Locale.ENGLISH);
        axis.setFormat((Format)coordinateFormat);
        axis.addActionListener(listener);
        axis.setErrorValidationStrategy(new ValidationStrategy[]{this.getHardLimitValidationStrategy(Units.getMetersConverter(), hardLimit)});
        int coordinateDecimalPlaces = this.isUS() ? 3 : 2;
        axis.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)coordinateDecimalPlaces)});
        axis.setName(name);
    }

    @Override
    public void bindRotation(NumberField rotation, ActionListener listener, String name) {
        rotation.setFormat((Format)ROTATION_FORMATTER);
        rotation.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getNumberValidator()});
        rotation.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)4)});
        rotation.addActionListener(listener);
        rotation.setName(name);
    }

    @Override
    public void bindPayload(NumberField payload, ActionListener listener, String name) {
        DecimalFormat twoDecimals = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"##0.00", (Locale)Locale.ENGLISH);
        payload.setFormat((Format)twoDecimals);
        payload.setErrorValidationStrategy(new ValidationStrategy[]{(ValidationStrategy)this.payloadValidationStrategyProvider.get()});
        PayloadWarningValidationStrategy soft = (PayloadWarningValidationStrategy)this.payloadWarningValidationStrategyProvider.get();
        soft.setHardLimits(false);
        ValidationStrategy dec = ValidationFactory.getDecimalPlacesValidator((int)2);
        ValidationStrategy.Composite com = new ValidationStrategy.Composite(new ValidationStrategy[0]);
        com.add(dec);
        com.add((ValidationStrategy)soft);
        payload.setWarningValidationStrategy(new ValidationStrategy[]{com});
        payload.addActionListener(listener);
        payload.setName(name);
    }

    private ValidationStrategy getHardLimitValidationStrategy(UnitsConverter converter, double maximum) {
        double convertedMaximum = converter.convertFrom(maximum);
        double convertedMinimum = -convertedMaximum;
        String outOfBoundsErrorMessage = this.textResource.valueOutOfRange(convertedMinimum, converter.getUnit(), convertedMaximum);
        return ValidationFactory.getRangeValidator((double)convertedMinimum, (double)convertedMaximum, (String)outOfBoundsErrorMessage);
    }
}

