/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.injection.HasKey;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.entities.TCPPresetImpl;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.internal.impl.TextResourceImpl;
import com.ur.reference.NameReference;
import com.ur.swing.LabelProvider;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.renderers.contributed.ContributedHeading;
import java.awt.FontMetrics;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.UIManager;

@HasKey(value="tcp-renderer")
public class TCPRenderingStrategy
implements RenderingStrategy {
    @Inject
    private static TextResource defaultResource = new TextResourceImpl(Locale.ENGLISH);
    private static final String TRUNCATE_SUFFIX = "...";
    private static final int MAX_WIDTH = 350;
    private final FontMetrics fontMetrics;
    private final InstallationComponentLookup installationLookupService;
    private final boolean withIcon;
    private final Map<TCP.TCPPreset, String> tcpPresetMap;
    private LabelProvider<Object> labelProvider = new DefaultLabelProvider();

    @Inject
    public TCPRenderingStrategy(InstallationComponentLookup installationLookupService, TextResource textResource) {
        this(installationLookupService, textResource, true);
    }

    public TCPRenderingStrategy(InstallationComponentLookup installationLookupService, TextResource textResource, boolean withIcon) {
        this.installationLookupService = installationLookupService;
        this.withIcon = withIcon;
        this.fontMetrics = new JComboBox().getFontMetrics(UIManager.getFont("ComboBox.font"));
        this.tcpPresetMap = this.createTCPPresetMap(textResource);
    }

    public static RenderingStrategy createWithoutIcon(InstallationComponentLookup lookupService, LabelProvider<Object> labelProvider) {
        TCPRenderingStrategy result = new TCPRenderingStrategy(lookupService, defaultResource, false);
        result.setAlternativeLabelProvider(labelProvider);
        return result;
    }

    private void setAlternativeLabelProvider(LabelProvider<Object> labelProvider) {
        if (labelProvider != null) {
            this.labelProvider = labelProvider;
        }
    }

    private Map<TCP.TCPPreset, String> createTCPPresetMap(TextResource textResource) {
        HashMap<TCP.TCPPreset, String> map = new HashMap<TCP.TCPPreset, String>();
        map.put(TCPPresetImpl.IGNORE_ACTIVE_TCP, textResource.IgnoreActiveTCP());
        map.put(TCPPresetImpl.USE_ACTIVE_TCP, textResource.UseActiveTCP());
        return map;
    }

    public String getText(Object value) {
        String result = "";
        if (value instanceof TCP) {
            result = ((TCP)value).getName();
        } else if (value instanceof NameReference) {
            result = ((NameReference)value).getKey();
        } else if (value instanceof TCP.TCPPreset) {
            result = this.tcpPresetMap.get(value);
        } else if (value instanceof ContributedHeading) {
            result = ((ContributedHeading)value).getDisplayName();
        } else if (value != null) {
            result = this.labelProvider.getText(value);
        }
        return this.truncate(result);
    }

    /*
     * Unable to fully structure code
     */
    private String truncate(String value) {
        if (this.fontMetrics != null) ** GOTO lbl5
        return value;
lbl-1000:
        // 1 sources

        {
            symbolsToCut = "...".length() + (value.endsWith("...") != false ? 1 : 0);
            value = String.valueOf(value.substring(0, value.length() - symbolsToCut)) + "...";
lbl5:
            // 2 sources

            ** while (this.fontMetrics.stringWidth((String)value) > 350)
        }
lbl6:
        // 1 sources

        return value;
    }

    public Icon getIcon(Object value) {
        if (this.withIcon && EqualsUtil.equals((Object)value, (Object)((TCPSettings)this.installationLookupService.getComponent(TCPSettings.class)).getSelectedTCP_Old())) {
            return TcpImageResource.defaultIconSelected();
        }
        return null;
    }

    public boolean hasError(Object value) {
        return this.getTCP(value) == null && !(value instanceof TCP.TCPPreset);
    }

    private TCP getTCP(Object value) {
        if (value instanceof TCP) {
            return (TCP)value;
        }
        if (value instanceof NameReference) {
            return (TCP)((NameReference)value).dereference();
        }
        return null;
    }

    private static class DefaultLabelProvider
    implements LabelProvider<Object> {
        private DefaultLabelProvider() {
        }

        public String getText(Object o) {
            return o.toString();
        }
    }
}

