/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.StringUtils;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.PlaneSpatialFeature;
import com.ur.polyscope.geomfeature.PoseSpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachCallback;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPanelBase;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class TCPTeachOrientationPanel
extends TCPTeachPanelBase {
    public static final String SET_BUTTON = "SetButton." + TCPTeachOrientationPanel.class.getSimpleName();
    public static final String CANCEL_BUTTON = "CancelButton." + TCPTeachOrientationPanel.class.getSimpleName();
    private static final NumberFormat ROTATION_FORMATTER = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    private final FeatureService featureService;
    private Object selectedFeature;
    private SpatialFeature feature;
    private Pose6d pointPose;
    private Vector3d calculatedRotationOffset;
    private MainState mainState;
    private TCPTeachCallback tcpTeachCallback;
    private JButton cancel;
    private JLabel description;
    private JComboBox featureSelection;
    private JLabel mainStatus;
    private JButton set;
    private JButton setPosition1;
    private JLabel title;

    public TCPTeachOrientationPanel(TCPTeachCallback tcpTeachCallback, TextResource textResource, PositionRequester positionRequester, FeatureService featureService) {
        super(tcpTeachCallback.getTeachCallbackCardPanel(), textResource, positionRequester);
        this.tcpTeachCallback = tcpTeachCallback;
        this.featureService = featureService;
        this.feature = null;
        this.pointPose = null;
        this.calculatedRotationOffset = null;
        this.mainState = MainState.FEATURE_NOT_SELECTED;
        this.initComponents();
        this.bindComponents();
    }

    private void bindComponents() {
        this.title.setText(this.textResource.TeachTCPOrientationTitle());
        this.title.setFont(this.title.getFont().deriveFont(1));
        this.description.setText(HTML.html((String)this.textResource.TeachTCPOrientationDescription()));
        this.featureSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TCPTeachOrientationPanel.this.featureSelection.getSelectedItem() instanceof String) {
                    TCPTeachOrientationPanel.this.feature = null;
                } else if (TCPTeachOrientationPanel.this.featureSelection.getSelectedItem() instanceof SpatialFeature) {
                    TCPTeachOrientationPanel.this.feature = (SpatialFeature)TCPTeachOrientationPanel.this.featureSelection.getSelectedItem();
                }
                TCPTeachOrientationPanel.this.enter();
            }
        });
        this.set.setName(SET_BUTTON);
        this.set.setText(this.textResource.Set());
        this.set.setIcon(TcpImageResource.gtkOk());
        this.cancel.setName(CANCEL_BUTTON);
        this.cancel.setText(this.textResource.Cancel());
        this.cancel.setIcon(TcpImageResource.gtkCancel());
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.isActive()) {
            this.reset();
            this.updateState();
            this.updateComponents();
            if (this.selectedFeature != null) {
                this.featureSelection.setSelectedItem(this.selectedFeature);
            }
        }
    }

    @Override
    protected void reset() {
        this.feature = null;
        this.pointPose = null;
        this.calculatedRotationOffset = null;
    }

    @Override
    protected void saveReceivedPose(Pose6d pose) {
        this.pointPose = pose;
    }

    @Override
    protected void calculateTCPOffset() {
        if (this.feature == null || this.pointPose == null) {
            this.calculatedRotationOffset = null;
            return;
        }
        Matrix3d pointRotation = new Matrix3d();
        Pose6dTransformUtils.getTransform3D((Pose6d)this.pointPose).get(pointRotation);
        Matrix3d featureRotation = new Matrix3d();
        Pose6dTransformUtils.getTransform3D((Pose6d)new Pose6d(this.feature.getSpatialPose().asArray())).get(featureRotation);
        Matrix3d tcpOffsetAsRotationMatrix = this.getRotationDifference(pointRotation, featureRotation);
        this.calculatedRotationOffset = this.getRotationVector(tcpOffsetAsRotationMatrix);
    }

    private Matrix3d getRotationDifference(Matrix3d from, Matrix3d to) {
        Matrix3d result = new Matrix3d(from);
        result.transpose();
        result.mul(to);
        return result;
    }

    private Vector3d getRotationVector(Matrix3d offsetAsRotationMatrix) {
        AxisAngle4d axisAngle = new AxisAngle4d();
        axisAngle.set(offsetAsRotationMatrix);
        Vector3d result = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        result.scale(axisAngle.angle);
        return result;
    }

    @Override
    protected void updateState() {
        this.mainState = this.feature == null ? MainState.FEATURE_NOT_SELECTED : (this.pointPose == null ? MainState.POINT_NOT_SET : MainState.OK);
    }

    @Override
    protected void updateComponents() {
        this.featureSelection.setModel(this.createFeatureSelectionModel());
        if (this.feature != null) {
            this.featureSelection.setSelectedItem(this.feature);
        }
        this.setIcon(this.mainState, this.mainStatus);
        this.setText(this.mainState, this.mainStatus);
        if (this.pointPose == null) {
            this.setPosition1.setText(this.textResource.SetPoint());
        } else {
            this.setPosition1.setText(this.textResource.ModifyPoint());
        }
        this.set.setEnabled(this.mainState == MainState.OK);
    }

    private DefaultComboBoxModel createFeatureSelectionModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("<" + this.textResource.Undefined() + ">");
        for (SpatialFeature each : this.featureService.getAllSpatialFeatures()) {
            if (!(each instanceof BaseSpatialFeature) && !(each instanceof PoseSpatialFeature) && !(each instanceof PlaneSpatialFeature)) continue;
            model.addElement((String)each);
        }
        return model;
    }

    private void setIcon(MainState state, JLabel label) {
        switch (state) {
            case FEATURE_NOT_SELECTED: 
            case POINT_NOT_SET: {
                label.setIcon(this.grayLed);
                break;
            }
            case OK: {
                label.setIcon(this.greenLed);
            }
        }
    }

    private void setText(MainState state, JLabel label) {
        switch (state) {
            case FEATURE_NOT_SELECTED: {
                label.setText(HTML.html((String)this.textResource.FeatureNotSelected()));
                break;
            }
            case POINT_NOT_SET: {
                label.setText(HTML.html((String)this.textResource.PointNotSet()));
                break;
            }
            case OK: {
                label.setText(this.getCalculatedTCPOffsetText());
            }
        }
    }

    private String getCalculatedTCPOffsetText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.textResource.CalculatedOrientation());
        sb.append(": ");
        sb.append(HTML.br());
        sb.append("&nbsp;&nbsp;");
        sb.append("[");
        sb.append(StringUtils.joinStringsWith((String)", ", (Object[])new String[]{ROTATION_FORMATTER.format(this.calculatedRotationOffset.x), ROTATION_FORMATTER.format(this.calculatedRotationOffset.y), ROTATION_FORMATTER.format(this.calculatedRotationOffset.z)}));
        sb.append("]");
        return HTML.html((String)sb.toString());
    }

    @Override
    protected void setActionPerformed(ActionEvent evt) {
        this.tcpTeachCallback.setOrientationOffset(this.calculatedRotationOffset);
        this.setActive(false);
        this.tcpTeachCallback.teachComplete();
        if (this.featureSelection != null) {
            this.selectedFeature = this.featureSelection.getSelectedItem();
        }
    }

    @Override
    protected void cancelActionPerformed(ActionEvent evt) {
        this.setActive(false);
        this.tcpTeachCallback.teachComplete();
    }

    private void setPosition1ActionPerformed() {
        this.switchToMoveTab();
    }

    private void initComponents() {
        this.title = new JLabel();
        this.mainStatus = new JLabel();
        this.description = new JLabel();
        this.featureSelection = new JComboBox();
        Box.Filler featureSelectionGap = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.setPosition1 = new JButton();
        Box.Filler aboveExitPanelGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        JPanel exitPanel = new JPanel();
        this.set = new JButton();
        Box.Filler exitPanelFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(20, 0));
        this.cancel = new JButton();
        Box.Filler belowExitPanelGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 5));
        this.setLayout(new BoxLayout(this, 3));
        this.title.setText("<Teach TCP Orientation>");
        this.title.setAlignmentX(0.5f);
        this.title.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        this.add(this.title);
        this.mainStatus.setText("<html>&lt;A feature needs to be selected&gt;</html>");
        this.mainStatus.setAlignmentX(0.5f);
        this.mainStatus.setBorder(BorderFactory.createEmptyBorder(5, 0, 20, 0));
        this.mainStatus.setPreferredSize(new Dimension(200, 50));
        this.add(this.mainStatus);
        this.description.setText("<html>&lt;Choose a feature. Then set a point with the TCP pointing in the direction opposite to the Z-axis of the selected feature.&gt;</html>");
        this.description.setAlignmentX(0.5f);
        this.description.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.add(this.description);
        this.featureSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.featureSelection.setMaximumSize(new Dimension(200, 25));
        this.featureSelection.setPreferredSize(new Dimension(200, 25));
        this.add(this.featureSelection);
        this.add(featureSelectionGap);
        this.setPosition1.setText("<Set point>");
        this.setPosition1.setAlignmentX(0.5f);
        this.setPosition1.setMaximumSize(new Dimension(200, 50));
        this.setPosition1.setPreferredSize(new Dimension(200, 40));
        this.setPosition1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCPTeachOrientationPanel.this.setPosition1ActionPerformed();
            }
        });
        this.add(this.setPosition1);
        this.add(aboveExitPanelGap);
        exitPanel.setLayout(new BoxLayout(exitPanel, 2));
        exitPanel.setAlignmentX(0.5f);
        this.set.setText("<Set>");
        this.set.setMargin(new Insets(4, 4, 4, 4));
        this.set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCPTeachOrientationPanel.this.setActionPerformed(evt);
            }
        });
        this.cancel.setText("<Cancel>");
        this.cancel.setMargin(new Insets(4, 4, 4, 4));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCPTeachOrientationPanel.this.cancelActionPerformed(evt);
            }
        });
        exitPanel.add(this.set);
        exitPanel.add(exitPanelFiller);
        exitPanel.add(this.cancel);
        this.add(exitPanel);
        this.add(belowExitPanelGap);
    }

    private static enum MainState {
        FEATURE_NOT_SELECTED,
        POINT_NOT_SET,
        OK;

    }
}

