/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.swing.CardPanel;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class TCPTeachPanelBase
extends JPanel {
    private final CardPanel currentCardPanel;
    protected final TextResource textResource;
    private PositionRequester positionRequester;
    protected final Icon grayLed;
    protected final Icon redLed;
    protected final Icon yellowLed;
    protected final Icon greenLed;
    protected boolean active;

    protected TCPTeachPanelBase(CardPanel currentCardPanel, TextResource textResource, PositionRequester positionRequester) {
        this.currentCardPanel = currentCardPanel;
        this.textResource = textResource;
        this.positionRequester = positionRequester;
        this.grayLed = TcpImageResource.grayLed();
        this.redLed = TcpImageResource.redLed();
        this.yellowLed = TcpImageResource.yellowLed();
        this.greenLed = TcpImageResource.greenLed();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!this.isActive()) {
            this.reset();
        }
    }

    protected abstract void reset();

    protected void enter() {
        this.calculateTCPOffset();
        this.updateState();
        this.updateComponents();
    }

    protected abstract void saveReceivedPose(Pose6d var1);

    protected abstract void calculateTCPOffset();

    protected abstract void updateState();

    protected abstract void updateComponents();

    protected abstract void setActionPerformed(ActionEvent var1);

    protected abstract void cancelActionPerformed(ActionEvent var1);

    protected void switchToMoveTab() {
        this.positionRequester.requestPosition(this.currentCardPanel, new MoveCallback(){

            public void onOk(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
                Pose6d newPose = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)pose, (Pose6d)tcpOffset, (Pose6d)new Pose6d());
                TCPTeachPanelBase.this.saveReceivedPose(newPose);
                TCPTeachPanelBase.this.enter();
            }

            public void onCancel() {
            }
        });
    }
}

