/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachCallback;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPTeachPanelBase;
import com.ur.polyscope.internaltcp.internal.TcpImageResource;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class TCPTeachPositionPanel
extends TCPTeachPanelBase {
    public static final String SET_BUTTON = "SetButton." + TCPTeachPositionPanel.class.getSimpleName();
    public static final String CANCEL_BUTTON = "CancelButton." + TCPTeachPositionPanel.class.getSimpleName();
    private static final double MINIMUM_SINGULAR_VALUE = 1.0E-6;
    private static final double PRECISION_ERROR_THRESHOLD = 0.05;
    private static final double PRECISION_WARNING_THRESHOLD = 0.01;
    private static final UnitsConverter COORDINATE_CONVERTER = Units.getMetersConverter();
    private final Map<Point, Pose6d> pointPose;
    private final Map<Point, JButton> pointButton;
    private final Map<Point, PointState> pointState;
    private Point pointBeingSet;
    private TCPOffsetCalculator tcpOffsetCalculator;
    private MainState mainState;
    private TCPTeachCallback tcpTeachCallback;
    private JButton cancel;
    private JLabel description;
    private JLabel mainStatus;
    private JButton setTCP;
    private JButton setPosition1;
    private JButton setPosition2;
    private JButton setPosition3;
    private JButton setPosition4;
    private JLabel title;

    public TCPTeachPositionPanel(TCPTeachCallback tcpTeachCallback, TextResource textResource, PositionRequester positionRequester) {
        super(tcpTeachCallback.getTeachCallbackCardPanel(), textResource, positionRequester);
        this.tcpTeachCallback = tcpTeachCallback;
        this.pointPose = new EnumMap<Point, Pose6d>(Point.class);
        this.pointButton = new EnumMap<Point, JButton>(Point.class);
        this.pointBeingSet = null;
        this.tcpOffsetCalculator = null;
        this.mainState = MainState.MORE_POINTS_NEEDED;
        this.pointState = new EnumMap<Point, PointState>(Point.class);
        this.initComponents();
        this.bindComponents();
    }

    private void bindComponents() {
        this.title.setText(this.textResource.TeachTCPPositionTitle());
        this.title.setFont(this.title.getFont().deriveFont(1));
        this.description.setText(HTML.html((String)this.textResource.TeachTCPPositionDescription()));
        this.pointButton.put(Point.FIRST, this.setPosition1);
        this.pointButton.put(Point.SECOND, this.setPosition2);
        this.pointButton.put(Point.THIRD, this.setPosition3);
        this.pointButton.put(Point.FOURTH, this.setPosition4);
        this.setTCP.setName(SET_BUTTON);
        this.setTCP.setText(this.textResource.Set());
        this.setTCP.setIcon(TcpImageResource.gtkOk());
        this.cancel.setName(CANCEL_BUTTON);
        this.cancel.setText(this.textResource.Cancel());
        this.cancel.setIcon(TcpImageResource.gtkCancel());
    }

    @Override
    protected void reset() {
        this.pointPose.clear();
        this.tcpOffsetCalculator = null;
        this.updateState();
        this.updateComponents();
    }

    @Override
    protected void saveReceivedPose(Pose6d pose) {
        if (this.pointBeingSet != null) {
            this.pointPose.put(this.pointBeingSet, pose);
            this.pointBeingSet = null;
        }
    }

    @Override
    protected void calculateTCPOffset() {
        List<Pose6d> poses = this.getSpecifiedPoses();
        if (poses.size() == 3) {
            this.tcpOffsetCalculator = new TCPOffsetCalculator(poses);
        } else if (poses.size() == 4) {
            ArrayList<TCPOffsetCalculator> calculators = new ArrayList<TCPOffsetCalculator>();
            double bestSeenAverageDistance = Double.MAX_VALUE;
            int bestCalculator = 0;
            int i = 0;
            while (i < 4) {
                ArrayList<Pose6d> modifiedPoses = new ArrayList<Pose6d>(poses);
                modifiedPoses.remove(poses.get(i));
                TCPOffsetCalculator calculator = new TCPOffsetCalculator(modifiedPoses);
                calculators.add(calculator);
                double averageDistance = calculator.getAverageDistance();
                if (averageDistance < bestSeenAverageDistance) {
                    bestSeenAverageDistance = averageDistance;
                    bestCalculator = i;
                }
                ++i;
            }
            this.tcpOffsetCalculator = (TCPOffsetCalculator)calculators.get(bestCalculator);
        }
    }

    private List<Pose6d> getSpecifiedPoses() {
        ArrayList<Pose6d> poses = new ArrayList<Pose6d>();
        Point[] pointArray = Point.values();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point each = pointArray[n2];
            Pose6d eachPose = this.pointPose.get((Object)each);
            if (eachPose != null) {
                poses.add(eachPose);
            }
            ++n2;
        }
        return poses;
    }

    private Vector3d getTranslation(Pose6d each) {
        Vector3d result = new Vector3d();
        Pose6dTransformUtils.getTransform3D((Pose6d)each).get(result);
        return result;
    }

    private double[][] getRotationMatrix(Pose6d pose) {
        Matrix3d rotationMatrix = new Matrix3d();
        Pose6dTransformUtils.getTransform3D((Pose6d)pose).get(rotationMatrix);
        return new double[][]{{rotationMatrix.m00, rotationMatrix.m01, rotationMatrix.m02}, {rotationMatrix.m10, rotationMatrix.m11, rotationMatrix.m12}, {rotationMatrix.m20, rotationMatrix.m21, rotationMatrix.m22}};
    }

    @Override
    protected void updateState() {
        boolean morePointsNeeded = this.getSpecifiedPoses().size() <= 2;
        boolean isError = false;
        boolean isWarning = false;
        Point[] pointArray = Point.values();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point each = pointArray[n2];
            if (!this.isPointSet(each)) {
                this.pointState.put(each, PointState.NOT_SET);
            } else if (morePointsNeeded) {
                this.pointState.put(each, PointState.MORE_POINTS_NEEDED);
            } else if (!this.tcpOffsetCalculator.isDataSufficient()) {
                this.pointState.put(each, PointState.INSUFFICIENT_INFORMATION);
            } else if (this.hasPrecisionError(each)) {
                isError = true;
                this.pointState.put(each, PointState.PRECISION_ERROR);
            } else if (this.hasPrecisionWarning(each)) {
                isWarning = true;
                this.pointState.put(each, PointState.PRECISION_WARNING);
            } else {
                this.pointState.put(each, PointState.OK);
            }
            ++n2;
        }
        this.mainState = this.getMainState(morePointsNeeded, isError, isWarning);
    }

    private MainState getMainState(boolean morePointsNeeded, boolean isError, boolean isWarning) {
        if (morePointsNeeded) {
            return MainState.MORE_POINTS_NEEDED;
        }
        return MainState.getMainState(this.tcpOffsetCalculator, isError, isWarning);
    }

    private boolean hasPrecisionWarning(Point point) {
        return this.tcpOffsetCalculator.getDistanceFromCalculatedPoint(point) > 0.01;
    }

    private boolean hasPrecisionError(Point point) {
        return this.tcpOffsetCalculator.getDistanceFromCalculatedPoint(point) > 0.05;
    }

    @Override
    protected void updateComponents() {
        this.setIcon(this.mainState, this.mainStatus);
        this.setText(this.mainState, this.mainStatus);
        Point[] pointArray = Point.values();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point each = pointArray[n2];
            JButton eachButton = this.pointButton.get((Object)each);
            this.setIcon(each, eachButton);
            this.setText(each, eachButton);
            Point previous = each.previous();
            eachButton.setEnabled(previous == null || this.pointState.get((Object)previous) != PointState.NOT_SET);
            ++n2;
        }
        this.setTCP.setEnabled(EqualsUtil.equalsOneOf((Object)((Object)this.mainState), (Object[])new MainState[]{MainState.PRECISION_WARNING, MainState.OK}));
    }

    private void setIcon(MainState state, JLabel label) {
        switch (state) {
            case MORE_POINTS_NEEDED: {
                label.setIcon(this.grayLed);
                break;
            }
            case INSUFFICIENT_INFORMATION: 
            case PRECISION_ERROR: {
                label.setIcon(this.redLed);
                break;
            }
            case PRECISION_WARNING: {
                label.setIcon(this.yellowLed);
                break;
            }
            case OK: {
                label.setIcon(this.greenLed);
            }
        }
    }

    private void setText(MainState state, JLabel label) {
        switch (state) {
            case MORE_POINTS_NEEDED: {
                label.setText(HTML.html((String)this.textResource.MorePointsNeeded()));
                break;
            }
            case INSUFFICIENT_INFORMATION: {
                label.setText(HTML.html((String)this.textResource.PointsNotSufficientlyDiverse()));
                break;
            }
            case PRECISION_ERROR: 
            case PRECISION_WARNING: 
            case OK: {
                label.setText(this.getCalculatedTCPOffsetText());
            }
        }
    }

    private void setIcon(Point point, JButton button) {
        switch (this.pointState.get((Object)point)) {
            case NOT_SET: {
                button.setIcon(null);
                break;
            }
            case MORE_POINTS_NEEDED: 
            case INSUFFICIENT_INFORMATION: {
                button.setIcon(this.grayLed);
                break;
            }
            case PRECISION_ERROR: {
                button.setIcon(this.redLed);
                break;
            }
            case PRECISION_WARNING: {
                button.setIcon(this.yellowLed);
                break;
            }
            case OK: {
                button.setIcon(this.greenLed);
            }
        }
    }

    private void setText(Point point, JButton button) {
        if (this.pointState.get((Object)point) == PointState.NOT_SET) {
            button.setText(this.textResource.SetPointNumber(point.getId()));
        } else {
            button.setText(this.textResource.ModifyPointNumber(point.getId()));
        }
    }

    private String getCalculatedTCPOffsetText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.textResource.CalculatedPosition());
        sb.append(": ");
        sb.append(HTML.br());
        sb.append("&nbsp;&nbsp;");
        sb.append("[");
        sb.append(StringUtils.joinStringsWith((String)", ", (Object[])new Double[]{COORDINATE_CONVERTER.convertFrom(((TCPOffsetCalculator)this.tcpOffsetCalculator).calculatedTCPOffset.x), COORDINATE_CONVERTER.convertFrom(((TCPOffsetCalculator)this.tcpOffsetCalculator).calculatedTCPOffset.y), COORDINATE_CONVERTER.convertFrom(((TCPOffsetCalculator)this.tcpOffsetCalculator).calculatedTCPOffset.z)}));
        sb.append("]");
        return HTML.html((String)sb.toString());
    }

    private boolean isPointSet(Point position) {
        return this.pointPose.get((Object)position) != null;
    }

    @Override
    protected void setActionPerformed(ActionEvent evt) {
        this.tcpTeachCallback.setPositionOffset(this.tcpOffsetCalculator.calculatedTCPOffset);
        this.setActive(false);
        this.tcpTeachCallback.teachComplete();
    }

    @Override
    protected void cancelActionPerformed(ActionEvent evt) {
        this.setActive(false);
        this.tcpTeachCallback.teachComplete();
    }

    private void setPosition1ActionPerformed() {
        this.pointBeingSet = Point.FIRST;
        this.switchToMoveTab();
    }

    private void setPosition2ActionPerformed() {
        this.pointBeingSet = Point.SECOND;
        this.switchToMoveTab();
    }

    private void setPosition3ActionPerformed() {
        this.pointBeingSet = Point.THIRD;
        this.switchToMoveTab();
    }

    private void setPosition4ActionPerformed() {
        this.pointBeingSet = Point.FOURTH;
        this.switchToMoveTab();
    }

    private void initComponents() {
        this.title = new JLabel("<Teach TCP Position>");
        this.mainStatus = new JLabel("<html>&lt;More points needed&gt;</html>");
        this.description = new JLabel("<html>&lt;Move the TCP to the same position from different directions.&gt;</html>");
        JPanel positionPanel = new JPanel();
        this.setPosition1 = new JButton(this.textResource.setPositionPoint(1));
        Box.Filler buttonGap1 = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.setPosition2 = new JButton(this.textResource.setPositionPoint(2));
        Box.Filler buttonGap2 = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.setPosition3 = new JButton(this.textResource.setPositionPoint(3));
        Box.Filler buttonGap3 = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.setPosition4 = new JButton(this.textResource.setPositionPoint(4));
        Box.Filler aboveExitPanelGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        JPanel exitPanel = new JPanel();
        this.setTCP = new JButton("<Set>");
        Box.Filler exitPanelFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(20, 0));
        this.cancel = new JButton("<Cancel>");
        Box.Filler belowExitPanelGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 5));
        this.setLayout(new BoxLayout(this, 3));
        this.title.setAlignmentX(0.5f);
        this.title.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        this.add(this.title);
        this.mainStatus.setAlignmentX(0.5f);
        this.mainStatus.setBorder(BorderFactory.createEmptyBorder(5, 0, 20, 0));
        this.mainStatus.setPreferredSize(new Dimension(200, 50));
        this.add(this.mainStatus);
        this.description.setAlignmentX(0.5f);
        this.description.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.add(this.description);
        positionPanel.setLayout(new BoxLayout(positionPanel, 3));
        this.setPosition1.setAlignmentX(0.5f);
        this.setPosition1.setMaximumSize(new Dimension(200, 50));
        this.setPosition1.setPreferredSize(new Dimension(200, 40));
        this.setPosition1.addActionListener(evt -> this.setPosition1ActionPerformed());
        positionPanel.add(this.setPosition1);
        positionPanel.add(buttonGap1);
        this.setPosition2.setAlignmentX(0.5f);
        this.setPosition2.setMaximumSize(new Dimension(200, 50));
        this.setPosition2.setPreferredSize(new Dimension(200, 40));
        this.setPosition2.addActionListener(evt -> this.setPosition2ActionPerformed());
        positionPanel.add(this.setPosition2);
        positionPanel.add(buttonGap2);
        this.setPosition3.setAlignmentX(0.5f);
        this.setPosition3.setMaximumSize(new Dimension(200, 50));
        this.setPosition3.setPreferredSize(new Dimension(200, 40));
        this.setPosition3.addActionListener(evt -> this.setPosition3ActionPerformed());
        positionPanel.add(this.setPosition3);
        positionPanel.add(buttonGap3);
        this.setPosition4.setAlignmentX(0.5f);
        this.setPosition4.setMaximumSize(new Dimension(200, 50));
        this.setPosition4.setPreferredSize(new Dimension(200, 40));
        this.setPosition4.addActionListener(evt -> this.setPosition4ActionPerformed());
        positionPanel.add(this.setPosition4);
        this.add(positionPanel);
        this.add(aboveExitPanelGap);
        exitPanel.setLayout(new BoxLayout(exitPanel, 2));
        exitPanel.setAlignmentX(0.5f);
        this.setTCP.setMargin(new Insets(4, 4, 4, 4));
        this.setTCP.addActionListener(this::setActionPerformed);
        this.cancel.setMargin(new Insets(4, 4, 4, 4));
        this.cancel.addActionListener(this::cancelActionPerformed);
        exitPanel.add(this.setTCP);
        exitPanel.add(exitPanelFiller);
        exitPanel.add(this.cancel);
        this.add(exitPanel);
        this.add(belowExitPanelGap);
    }

    private static enum MainState {
        MORE_POINTS_NEEDED,
        INSUFFICIENT_INFORMATION,
        PRECISION_ERROR,
        PRECISION_WARNING,
        OK;


        public static MainState getMainState(TCPOffsetCalculator calculator, boolean isError, boolean isWarning) {
            if (!calculator.isDataSufficient()) {
                return INSUFFICIENT_INFORMATION;
            }
            if (isError) {
                return PRECISION_ERROR;
            }
            if (isWarning) {
                return PRECISION_WARNING;
            }
            return OK;
        }
    }

    private static enum Point {
        FIRST(1),
        SECOND(2),
        THIRD(3),
        FOURTH(4);

        private int id;

        private Point(int id) {
            this.id = id;
        }

        private static Point byId(int id) {
            Point[] pointArray = Point.values();
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point each = pointArray[n2];
                if (each.id == id) {
                    return each;
                }
                ++n2;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public Point previous() {
            return Point.byId(this.id - 1);
        }
    }

    private static enum PointState {
        NOT_SET,
        MORE_POINTS_NEEDED,
        INSUFFICIENT_INFORMATION,
        PRECISION_ERROR,
        PRECISION_WARNING,
        OK;

    }

    private class TCPOffsetCalculator {
        private final List<Pose6d> poses;
        private Vector3d calculatedTCPOffset;
        private Vector3d calculatedApproachPoint;

        public TCPOffsetCalculator(List<Pose6d> poses) {
            this.poses = poses;
            this.calculateTCPOffsetUsingLeastSquares();
        }

        public boolean isDataSufficient() {
            return this.calculatedTCPOffset != null;
        }

        public double getAverageDistance() {
            if (this.isDataSufficient()) {
                double result = 0.0;
                Point[] pointArray = Point.values();
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point each = pointArray[n2];
                    result += this.getDistanceFromCalculatedPoint(each);
                    ++n2;
                }
                return result / (double)Point.values().length;
            }
            return Double.MAX_VALUE;
        }

        public double getDistanceFromCalculatedPoint(Point point) {
            Matrix3d pointRotationMatrix = new Matrix3d();
            Pose6dTransformUtils.getTransform3D((Pose6d)((Pose6d)TCPTeachPositionPanel.this.pointPose.get((Object)point))).get(pointRotationMatrix);
            Point3d calculatedPoint = new Point3d((Tuple3d)this.calculatedApproachPoint);
            Vector3d tcpOffset = new Vector3d(this.calculatedTCPOffset);
            pointRotationMatrix.transform((Tuple3d)tcpOffset);
            calculatedPoint.sub((Tuple3d)tcpOffset);
            Point3d originalPoint = new Point3d((Tuple3d)((Pose6d)TCPTeachPositionPanel.this.pointPose.get((Object)point)).getPos());
            return calculatedPoint.distance(originalPoint);
        }

        private void calculateTCPOffsetUsingLeastSquares() {
            RealMatrix linearSystemCoefficients = MatrixUtils.createRealMatrix((int)(this.poses.size() * 3), (int)6);
            RealVector linearSystemConstantPart = MatrixUtils.createRealVector((double[])new double[this.poses.size() * 3]);
            RealMatrix minusIdentity = MatrixUtils.createRealDiagonalMatrix((double[])new double[]{-1.0, -1.0, -1.0});
            int poseCounter = 0;
            for (Pose6d each : this.poses) {
                double[][] eachRotationMatrix = TCPTeachPositionPanel.this.getRotationMatrix(each);
                linearSystemCoefficients.setSubMatrix(eachRotationMatrix, poseCounter * 3, 0);
                linearSystemCoefficients.setSubMatrix(minusIdentity.getData(), poseCounter * 3, 3);
                Vector3d translation = TCPTeachPositionPanel.this.getTranslation(each);
                linearSystemConstantPart.setEntry(poseCounter * 3, -translation.x);
                linearSystemConstantPart.setEntry(poseCounter * 3 + 1, -translation.y);
                linearSystemConstantPart.setEntry(poseCounter * 3 + 2, -translation.z);
                ++poseCounter;
            }
            RealMatrix normalSystemCoefficients = linearSystemCoefficients.transpose().multiply(linearSystemCoefficients);
            SingularValueDecomposition svd = new SingularValueDecomposition(normalSystemCoefficients);
            double[] singularValues = svd.getSingularValues();
            if (singularValues[singularValues.length - 1] >= 1.0E-6) {
                RealMatrix normalSystemCoefficientsInverse = svd.getSolver().getInverse();
                RealVector tcpOffsetAndApproachedPoint = normalSystemCoefficientsInverse.multiply(linearSystemCoefficients.transpose()).operate(linearSystemConstantPart);
                this.calculatedTCPOffset = new Vector3d(tcpOffsetAndApproachedPoint.getEntry(0), tcpOffsetAndApproachedPoint.getEntry(1), tcpOffsetAndApproachedPoint.getEntry(2));
                this.calculatedApproachPoint = new Vector3d(tcpOffsetAndApproachedPoint.getEntry(3), tcpOffsetAndApproachedPoint.getEntry(4), tcpOffsetAndApproachedPoint.getEntry(5));
            }
        }
    }
}

