/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.infrastructure;

import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPConfigurationTab;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.swing.CompletedListener;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

final class UpdatePoseOnComplete
extends CompletedListener.Template {
    private final UnitsConverter coordinateConverter = Units.getMetersConverter();
    private final TCPConfigurationTab tcpConfigurationTab;
    private final InstallationComponentLookup installationLookupService;
    private final JComboBox rotationTypeComboBox;
    private final JComboBox tcpComboBox;
    private final JTextField[] poseTextFields;

    public UpdatePoseOnComplete(TCPConfigurationTab tcpConfigurationTab, InstallationComponentLookup installationLookupService, JComboBox tcpComboBox, JComboBox rotationTypeComboBox, JTextField ... poseTextFields) {
        this.tcpConfigurationTab = tcpConfigurationTab;
        this.installationLookupService = installationLookupService;
        this.tcpComboBox = tcpComboBox;
        this.rotationTypeComboBox = rotationTypeComboBox;
        this.poseTextFields = poseTextFields;
    }

    public void requestApply() {
        Vector3d rotation3d;
        TCP selectedTCP = (TCP)this.tcpComboBox.getSelectedItem();
        Pose6d selectedPose = selectedTCP.getOffset();
        Vector3d position3d = new Vector3d(this.translateCoordinate(this.poseTextFields[0].getText(), selectedPose.getX()), this.translateCoordinate(this.poseTextFields[1].getText(), selectedPose.getY()), this.translateCoordinate(this.poseTextFields[2].getText(), selectedPose.getZ()));
        if (this.rotationTypeComboBox != null) {
            RotationRepresentation rotationRepresentation = (RotationRepresentation)this.rotationTypeComboBox.getSelectedItem();
            Vector3d temp = new Vector3d(Double.parseDouble(this.poseTextFields[3].getText()), Double.parseDouble(this.poseTextFields[4].getText()), Double.parseDouble(this.poseTextFields[5].getText()));
            rotationRepresentation.setValues(temp);
            rotation3d = rotationRepresentation.getRotationVector(temp);
        } else {
            rotation3d = new Vector3d(this.translateRotation(this.poseTextFields[3].getText(), selectedPose.getRX()) % (Math.PI * 2), this.translateRotation(this.poseTextFields[4].getText(), selectedPose.getRY()) % (Math.PI * 2), this.translateRotation(this.poseTextFields[5].getText(), selectedPose.getRZ()) % (Math.PI * 2));
        }
        selectedTCP.setOffset(new Pose6d((Tuple3d)position3d, (Tuple3d)rotation3d));
        TCPSettings tcpSettings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        if (selectedTCP == tcpSettings.getSelectedTCP_Old()) {
            tcpSettings.selectTCP(selectedTCP.getName());
        }
        this.tcpComboBox.repaint();
        this.tcpConfigurationTab.updateComponents();
    }

    private double translateCoordinate(String toParse, double defaultValue) {
        return this.coordinateConverter.convertTo(PrimitiveUtils.parseDouble((String)toParse, (double)defaultValue));
    }

    private double translateRotation(String toParse, double defaultValue) {
        return PrimitiveUtils.parseDouble((String)toParse, (double)defaultValue);
    }
}

