/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.usecases;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPFactory;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.internal.impl.TextResourceImpl;
import java.util.Locale;
import java.util.UUID;
import javax.inject.Inject;

public class TCPFactoryImpl
implements TCPFactory {
    public static final String DEFAULT_TCP_NAME = "TCP";
    private final NamingService namingService;
    private TextResource textResource = new TextResourceImpl(Locale.ENGLISH);

    public TCPFactoryImpl(NamingService namingService) {
        this.namingService = namingService;
    }

    @Inject
    private TCPFactoryImpl(NamingService namingService, TextResource textResource) {
        this(namingService);
        this.textResource = textResource;
    }

    @Override
    public TCP create() {
        return this.create(new Pose6d());
    }

    @Override
    public TCP create(Pose6d offset) {
        return this.create(this.namingService.makeUniqueName(TCP.class, DEFAULT_TCP_NAME), offset);
    }

    @Override
    public TCP create(String name, Pose6d offset) {
        TCP result = new TCP(UUID.randomUUID(), name, offset);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public TCP create(String name, Pose6d offset, ContributorInfo contributorInfo) {
        TCPContributed result = new TCPContributed(UUID.randomUUID(), name, offset, contributorInfo);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public TCP create(UUID uuid, String name, Pose6d offset, ContributorInfo contributorInfo) {
        TCPContributed result = new TCPContributed(uuid, name, offset, contributorInfo);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public TCP createUndefinedTcp(Pose6d tcpOffset) {
        String undefinedActiveTCPName = this.textResource.ActiveTCP();
        return new TCP(UUID.randomUUID(), undefinedActiveTCPName, tcpOffset);
    }

    @Override
    public TCP create(UUID uuid, String name, Pose6d offset) {
        TCP result = new TCP(uuid, name, offset);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public void remove(TCP tcp) {
        this.namingService.deregisterNamedEntity((NamedEntity)tcp);
    }
}

