/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.usecases;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPObserver;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;

public class TCPNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;

    @Inject
    public TCPNamingStrategy(NamingService namingService) {
        super(TCP.class);
        this.namingService = namingService;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        if (StringUtils.isNullOrOnlyWhitespace((String)(nameCandidate = this.convertToValidName(nameCandidate)))) {
            return;
        }
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        String newName = this.namingService.isNameUsed(entity.getClass(), nameCandidate) ? this.namingService.makeUniqueName(TCP.class, nameCandidate) : nameCandidate;
        String oldName = entity.getName();
        entity.setName(newName);
        this.fireTCPNameChange((TCP)entity, oldName, newName);
    }

    private void fireTCPNameChange(final TCP tcp, final String oldName, final String newName) {
        EventNotificationService.notify(TCPObserver.class, (NotificationStrategy)new NotificationStrategy<TCPObserver>(){

            public void notify(TCPObserver listener) {
                listener.nameChanged(tcp, oldName, newName);
            }
        });
    }
}

