/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl.tcp.view;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.MoveTcpReference;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.internaltcp.impl.tcp.entities.TCPPresetImpl;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPComboBoxContentHolder;
import com.ur.polyscope.internaltcp.impl.tcp.infrastructure.TCPRenderingStrategy;
import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.program.Program;
import com.ur.polyscope.tcp.TCP;
import com.ur.reference.ReferenceService;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.WidgetFactory;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuListener;

@HasKey(value="g5-tcp-reference")
public class G5TcpReferenceView
implements ViewComponent {
    public static final String TCP_COMBO_BOX = "TCP_COMBO_BOX.MoveCard";
    private final TCPComboBoxContentHolder tcpComboBoxContentHolder;
    private final ReferenceService programReferenceService;
    private final InstallationComponentLookup installationLookup;
    private final ViewContext viewContext;
    private final ComboBox tcpComboBox;
    private final JPanel panel;
    private ViewComponent.ModifyListener modifyListener;
    private boolean isUpdating;

    @Inject
    public G5TcpReferenceView(TCPComboBoxContentHolder tcpComboBoxContentHolder, @Program ReferenceService programReferenceService, InstallationComponentLookup installationLookup, ViewContext viewContext) {
        this.tcpComboBoxContentHolder = tcpComboBoxContentHolder;
        this.programReferenceService = programReferenceService;
        this.installationLookup = installationLookup;
        this.viewContext = viewContext;
        WidgetFactory factory = viewContext.createWidgetFactory();
        TextResource text = (TextResource)viewContext.getTextResource(TextResource.class);
        JLabel label = factory.createLabel(text.setTCP());
        this.tcpComboBox = viewContext.createWidgetFactory().createComboBox();
        this.tcpComboBox.setName(TCP_COMBO_BOX);
        this.tcpComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)new TCPRenderingStrategy(installationLookup, (TextResource)viewContext.getTextResource(TextResource.class), false), 700));
        this.panel = viewContext.createFormBuilder().label(label, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.tcpComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().getRow();
        this.panel.addPropertyChangeListener("enabled", evt -> {
            boolean enabled = (Boolean)evt.getNewValue();
            label.setEnabled(enabled);
            this.tcpComboBox.setEnabled(enabled);
        });
        this.bind();
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.tcpComboBox, "gui:command_move:tcp_selection");
    }

    private DefaultComboBoxModel getTcpComboBoxModel() {
        DefaultComboBoxModel model = this.tcpComboBoxContentHolder.getTcpComboBoxModel();
        model.insertElementAt(TCPPresetImpl.IGNORE_ACTIVE_TCP, 0);
        model.insertElementAt(TCPPresetImpl.USE_ACTIVE_TCP, 1);
        return model;
    }

    private void bind() {
        this.tcpComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (G5TcpReferenceView.this.isUpdating) {
                    return;
                }
                TCPReference reference = null;
                boolean useActiveTCP = false;
                Object selectedItem = G5TcpReferenceView.this.tcpComboBox.getSelectedItem();
                if (selectedItem instanceof TCP) {
                    reference = (TCPReference)G5TcpReferenceView.this.programReferenceService.getReferenceTo(TCPReference.class, (Object)((TCP)selectedItem));
                } else if (selectedItem instanceof TCPReference) {
                    reference = (TCPReference)((Object)selectedItem);
                } else if (TCPPresetImpl.USE_ACTIVE_TCP.equals(selectedItem)) {
                    useActiveTCP = true;
                }
                G5TcpReferenceView.this.modifyListener.onModified((DomainComponent)new MoveTcpReference(useActiveTCP, reference));
            }
        });
        TCPRenderingStrategy tcpRenderingStrategy = new TCPRenderingStrategy(this.installationLookup, (TextResource)this.viewContext.getTextResource(TextResource.class), false);
        ComboBoxRenderer.bindRenderer((JComboBox)this.tcpComboBox, (RenderingStrategy)tcpRenderingStrategy);
        this.tcpComboBox.setRenderer((ListCellRenderer)new ContributedComboBoxRenderer((RenderingStrategy)tcpRenderingStrategy));
    }

    public JComponent asComponent() {
        return this.panel;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domainComponent) {
        this.isUpdating = true;
        MoveTcpReference tcpComponent = (MoveTcpReference)domainComponent;
        DefaultComboBoxModel tcpComboBoxModel = this.getTcpComboBoxModel();
        this.tcpComboBox.setModel((ComboBoxModel)tcpComboBoxModel);
        if (tcpComponent.isUseActiveTCP()) {
            this.tcpComboBox.setSelectedItem((Object)TCPPresetImpl.USE_ACTIVE_TCP);
        } else if (tcpComponent.getTcpReference() == null) {
            this.tcpComboBox.setSelectedItem((Object)TCPPresetImpl.IGNORE_ACTIVE_TCP);
        } else if (tcpComponent.hasValidTCP()) {
            this.tcpComboBox.setSelectedItem((Object)tcpComponent.getTcpReference().dereference());
        } else {
            TCPReference tcpReference = tcpComponent.getTcpReference();
            tcpComboBoxModel.insertElementAt(tcpReference, 0);
            tcpComboBoxModel.setSelectedItem((Object)tcpReference);
        }
        this.isUpdating = false;
    }
}

