/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class TcpImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            TcpImageResource.tryGetImage("toolAxisIllustration.png");
            TcpImageResource.tryGetImage("rename.png");
            TcpImageResource.tryGetImage("form-warning.png");
            TcpImageResource.tryGetImage("yellow_led.png");
            TcpImageResource.tryGetImage("default_icon.png");
            TcpImageResource.tryGetImage("gtk-cancel.png");
            TcpImageResource.tryGetImage("gtk-ok.png");
            TcpImageResource.tryGetImage("default_icon_selected.png");
            TcpImageResource.tryGetImage("gray_led.png");
            TcpImageResource.tryGetImage("red_led.png");
            TcpImageResource.tryGetImage("plus_icon.png");
            TcpImageResource.tryGetImage("toolAxisIllustrationSmall.png");
            TcpImageResource.tryGetImage("delete.png");
            TcpImageResource.tryGetImage("green_led.png");
            TcpImageResource.tryGetImage("wizard_icon.png");
        }
    }

    private TcpImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="toolAxisIllustration.png")
    public static @Key(value="toolAxisIllustration.png") Icon toolAxisIllustration() {
        return TcpImageResource.tryGetImage("toolAxisIllustration.png");
    }

    @Key(value="rename.png")
    public static @Key(value="rename.png") Icon rename() {
        return TcpImageResource.tryGetImage("rename.png");
    }

    @Key(value="form-warning.png")
    public static @Key(value="form-warning.png") Icon formWarning() {
        return TcpImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="yellow_led.png")
    public static @Key(value="yellow_led.png") Icon yellowLed() {
        return TcpImageResource.tryGetImage("yellow_led.png");
    }

    @Key(value="default_icon.png")
    public static @Key(value="default_icon.png") Icon defaultIcon() {
        return TcpImageResource.tryGetImage("default_icon.png");
    }

    @Key(value="gtk-cancel.png")
    public static @Key(value="gtk-cancel.png") Icon gtkCancel() {
        return TcpImageResource.tryGetImage("gtk-cancel.png");
    }

    @Key(value="gtk-ok.png")
    public static @Key(value="gtk-ok.png") Icon gtkOk() {
        return TcpImageResource.tryGetImage("gtk-ok.png");
    }

    @Key(value="default_icon_selected.png")
    public static @Key(value="default_icon_selected.png") Icon defaultIconSelected() {
        return TcpImageResource.tryGetImage("default_icon_selected.png");
    }

    @Key(value="gray_led.png")
    public static @Key(value="gray_led.png") Icon grayLed() {
        return TcpImageResource.tryGetImage("gray_led.png");
    }

    @Key(value="red_led.png")
    public static @Key(value="red_led.png") Icon redLed() {
        return TcpImageResource.tryGetImage("red_led.png");
    }

    @Key(value="plus_icon.png")
    public static @Key(value="plus_icon.png") Icon plusIcon() {
        return TcpImageResource.tryGetImage("plus_icon.png");
    }

    @Key(value="toolAxisIllustrationSmall.png")
    public static @Key(value="toolAxisIllustrationSmall.png") Icon toolAxisIllustrationSmall() {
        return TcpImageResource.tryGetImage("toolAxisIllustrationSmall.png");
    }

    @Key(value="delete.png")
    public static @Key(value="delete.png") Icon delete() {
        return TcpImageResource.tryGetImage("delete.png");
    }

    @Key(value="green_led.png")
    public static @Key(value="green_led.png") Icon greenLed() {
        return TcpImageResource.tryGetImage("green_led.png");
    }

    @Key(value="wizard_icon.png")
    public static @Key(value="wizard_icon.png") Icon wizardIcon() {
        return TcpImageResource.tryGetImage("wizard_icon.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return TcpImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

