/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.rotation;

import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.rotation.RPYRotationRadRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationVectorRadRepresentation;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class RPYRotationDegRepresentation
extends RPYRotationRadRepresentation {
    RPYRotationDegRepresentation(TextResource textResource) {
        super(RotationRepresentation.RotationType.ANGLES_DEGREES, textResource.rpyDeg(), textResource.degreesUnit());
    }

    @Override
    public Matrix3d getRotationMatrix() {
        return super.getRotationMatrix(new Vector3d(Math.PI / 180 * this.rotation.x, Math.PI / 180 * this.rotation.y, Math.PI / 180 * this.rotation.z));
    }

    @Override
    public Vector3d computeRotation(Vector3d rotationVector) {
        Matrix3d rotMat = RotationVectorRadRepresentation.getRotationMatrixForRotationVector(rotationVector);
        return this.computeRotation(rotMat);
    }

    @Override
    public Matrix3d getRotationMatrix(Vector3d rotation) {
        Vector3d rotationRad = new Vector3d();
        rotationRad.x = Math.PI / 180 * rotation.x;
        rotationRad.y = Math.PI / 180 * rotation.y;
        rotationRad.z = Math.PI / 180 * rotation.z;
        return super.getRotationMatrix(rotationRad);
    }

    @Override
    public Vector3d computeRotation(Matrix3d rotationMatrix) {
        Vector3d rotation = super.computeRotation(rotationMatrix);
        rotation.x = 57.29577951308232 * rotation.x;
        rotation.y = 57.29577951308232 * rotation.y;
        rotation.z = 57.29577951308232 * rotation.z;
        return rotation;
    }
}

