/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.rotation;

import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationVectorRadRepresentation;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class RPYRotationRadRepresentation
extends RotationRepresentation {
    private static boolean useFirstSolution = true;

    RPYRotationRadRepresentation(TextResource textResource) {
        super(RotationRepresentation.RotationType.ANGLES_RADIANS, textResource.rpyRad(), textResource.radUnit());
    }

    RPYRotationRadRepresentation(RotationRepresentation.RotationType type, String name, String unit) {
        super(type, name, unit);
    }

    @Override
    public Vector3d computeRotation(Vector3d rotationVector) {
        Matrix3d rotMat = RotationVectorRadRepresentation.getRotationMatrixForRotationVector(rotationVector);
        return this.computeRotation(rotMat);
    }

    @Override
    public void resetState() {
        useFirstSolution = true;
    }

    @Override
    public Matrix3d getRotationMatrix(Vector3d rotation) {
        Matrix3d rotMat = new Matrix3d();
        useFirstSolution = rotation.y <= 1.5707963267948966 && rotation.y >= -1.5707963267948966;
        double cosx = Math.cos(rotation.x);
        double sinx = Math.sin(rotation.x);
        double cosy = Math.cos(rotation.y);
        double siny = Math.sin(rotation.y);
        double cosz = Math.cos(rotation.z);
        double sinz = Math.sin(rotation.z);
        rotMat.m00 = cosz * cosy;
        rotMat.m01 = cosz * siny * sinx - sinz * cosx;
        rotMat.m02 = cosz * siny * cosx + sinz * sinx;
        rotMat.m10 = sinz * cosy;
        rotMat.m11 = sinz * siny * sinx + cosz * cosx;
        rotMat.m12 = sinz * siny * cosx - cosz * sinx;
        rotMat.m20 = -siny;
        rotMat.m21 = cosy * sinx;
        rotMat.m22 = cosy * cosx;
        return rotMat;
    }

    @Override
    public Vector3d computeRotation(Matrix3d rotationMatrix) {
        double gamma;
        double alpha;
        double beta = useFirstSolution ? Math.atan2(-rotationMatrix.m20, Math.sqrt(rotationMatrix.m00 * rotationMatrix.m00 + rotationMatrix.m10 * rotationMatrix.m10)) : Math.atan2(-rotationMatrix.m20, -Math.sqrt(rotationMatrix.m00 * rotationMatrix.m00 + rotationMatrix.m10 * rotationMatrix.m10));
        double epsilon = 1.0E-5;
        if (this.epsilonEquals(Math.abs(beta), 1.5707963267948966, epsilon)) {
            alpha = 0.0;
            gamma = beta / Math.abs(beta) * Math.atan2(rotationMatrix.m01, rotationMatrix.m11);
        } else {
            double cosBeta = Math.cos(beta);
            alpha = Math.atan2(rotationMatrix.m10 / cosBeta, rotationMatrix.m00 / cosBeta);
            gamma = Math.atan2(rotationMatrix.m21 / cosBeta, rotationMatrix.m22 / cosBeta);
        }
        return new Vector3d(gamma, beta, alpha);
    }
}

