/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.rotation;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public abstract class RotationRepresentation {
    static final double PI_2 = 1.5707963267948966;
    private final String name;
    private final String unit;
    private final RotationType type;
    protected Vector3d rotation = new Vector3d();
    boolean allowConversion;

    RotationRepresentation(RotationType type, String name, String unit) {
        this.type = type;
        this.name = name;
        this.unit = unit;
        this.allowConversion = true;
    }

    protected boolean epsilonEquals(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) < epsilon;
    }

    public void resetState() {
    }

    public RotationType getRotationType() {
        return this.type;
    }

    public String getUnits() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public Vector3d getValues() {
        return new Vector3d(this.rotation);
    }

    public void setValues(Vector3d rotation) {
        this.rotation.x = rotation.x;
        this.rotation.y = rotation.y;
        this.rotation.z = rotation.z;
    }

    public abstract Vector3d computeRotation(Matrix3d var1);

    public abstract Vector3d computeRotation(Vector3d var1);

    public abstract Matrix3d getRotationMatrix(Vector3d var1);

    public Vector3d getRotationVector(Vector3d rotation) {
        Matrix3d rotMat = this.getRotationMatrix(rotation);
        Quat4d quatRot = new Quat4d();
        quatRot.set(rotMat);
        AxisAngle4d axisAngleVec = new AxisAngle4d();
        axisAngleVec.set(quatRot);
        Vector3d rotVec = new Vector3d();
        rotVec.set(axisAngleVec.x, axisAngleVec.y, axisAngleVec.z);
        rotVec.x *= axisAngleVec.angle;
        rotVec.y *= axisAngleVec.angle;
        rotVec.z *= axisAngleVec.angle;
        return rotVec;
    }

    public Matrix3d getRotationMatrix() {
        return this.getRotationMatrix(this.rotation);
    }

    public void setAllowConversion(boolean allowConversion) {
        this.allowConversion = allowConversion;
    }

    public static enum RotationType {
        VECTOR,
        VECTOR_DEGREES,
        VECTOR_RADIANS,
        ANGLES_DEGREES,
        ANGLES_RADIANS;

    }
}

