/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.rotation;

import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.internal.impl.TextResourceImpl;
import com.ur.polyscope.internaltcp.rotation.RPYRotationDegRepresentation;
import com.ur.polyscope.internaltcp.rotation.RPYRotationRadRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationVectorDegRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationVectorRadRepresentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;

public class RotationRepresentationFactory {
    public static final double RAD_PER_DEGREE = Math.PI / 180;
    public static final double DEGREES_PER_RAD = 57.29577951308232;
    private static TextResource textResource = new TextResourceImpl(Locale.ENGLISH);

    @Inject
    public static void setTextResource(TextResource textResource) {
        RotationRepresentationFactory.textResource = textResource;
    }

    public static List<RotationRepresentation> createAll() {
        return RotationRepresentationFactory.createAll(textResource);
    }

    private static List<RotationRepresentation> createAll(TextResource textResource) {
        ArrayList<RotationRepresentation> list = new ArrayList<RotationRepresentation>();
        list.add(new RotationVectorRadRepresentation(textResource));
        list.add(new RotationVectorDegRepresentation(textResource));
        list.add(new RPYRotationRadRepresentation(textResource));
        list.add(new RPYRotationDegRepresentation(textResource));
        return list;
    }
}

