/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.rotation;

import com.ur.polyscope.internaltcp.internal.TextResource;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import javax.inject.Inject;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class RotationVectorRadRepresentation
extends RotationRepresentation {
    private static final double ROTATION_EPS = 0.001;
    private static TextResource textResource;

    public RotationVectorRadRepresentation(TextResource textResource) {
        super(RotationRepresentation.RotationType.VECTOR_RADIANS, textResource.rotationVectorRad(), textResource.radUnit());
    }

    RotationVectorRadRepresentation(RotationRepresentation.RotationType type, String name, String unit) {
        super(type, name, unit);
    }

    @Inject
    static void setTextResource(TextResource textResource) {
        RotationVectorRadRepresentation.textResource = textResource;
    }

    public static Vector3d getPresentableRotation(Vector3d rotationVector) {
        RotationVectorRadRepresentation rr = new RotationVectorRadRepresentation(textResource);
        return ((RotationRepresentation)rr).computeRotation(rotationVector);
    }

    public static Matrix3d getRotationMatrixForRotationVector(Vector3d rotationVector) {
        RotationVectorRadRepresentation rr = new RotationVectorRadRepresentation(textResource);
        return ((RotationRepresentation)rr).getRotationMatrix(rotationVector);
    }

    @Override
    public Vector3d computeRotation(Vector3d rotationVector) {
        return this.getRotationForPresentation(rotationVector);
    }

    @Override
    public Vector3d getRotationVector(Vector3d rotation) {
        return new Vector3d(rotation);
    }

    @Override
    public Matrix3d getRotationMatrix(Vector3d rotation) {
        Matrix3d rotMat = new Matrix3d();
        if (rotation.x == 0.0 && rotation.y == 0.0 && rotation.z == 0.0) {
            rotMat.setIdentity();
        } else {
            Vector3d rotVec = new Vector3d(rotation);
            double rotAngle = rotVec.length();
            rotVec.normalize();
            AxisAngle4d axisAngleVec = new AxisAngle4d(rotVec, rotAngle);
            rotMat.set(axisAngleVec);
        }
        return rotMat;
    }

    @Override
    public Vector3d computeRotation(Matrix3d rotationMatrix) {
        AxisAngle4d axisAngleVec = new AxisAngle4d();
        Quat4d quatRot = new Quat4d();
        quatRot.set(rotationMatrix);
        axisAngleVec.set(quatRot);
        double rotAngle = axisAngleVec.angle;
        Vector3d rotation = new Vector3d(axisAngleVec.x * rotAngle, axisAngleVec.y * rotAngle, axisAngleVec.z * rotAngle);
        return this.getRotationForPresentation(rotation);
    }

    private Vector3d getRotationForPresentation(Vector3d rotation) {
        Vector3d result = new Vector3d(rotation);
        if (this.allowConversion && (this.isRotationXBelowZero(rotation) || this.isRotationYBelowZero(rotation) || this.isRotationZBelowZero(rotation))) {
            double oldAngle = rotation.length();
            double newAngle = this.convertAngleToOppositeRotationVector(oldAngle);
            result.scale(-1.0 * newAngle / oldAngle);
        }
        return result;
    }

    private boolean isRotationXBelowZero(Vector3d rotation) {
        return Math.abs(rotation.x) >= 0.001 && rotation.x < 0.0;
    }

    private boolean isRotationYBelowZero(Vector3d rotation) {
        return Math.abs(rotation.x) < 0.001 && Math.abs(rotation.y) >= 0.001 && rotation.y < 0.0;
    }

    private boolean isRotationZBelowZero(Vector3d rotation) {
        return Math.abs(rotation.x) < 0.001 && Math.abs(rotation.y) < 0.001 && rotation.z < 0.0;
    }

    private double convertAngleToOppositeRotationVector(double angle) {
        return Math.PI * 2 - angle;
    }
}

