/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.poweron;

import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.RobotState;
import com.ur.monitor.requirements.AbstractRobotRequirement;
import com.ur.monitor.requirements.FailedRequirementListener;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;

public class PoweredOnRobotRequirement
extends AbstractRobotRequirement {
    private static final List<SafetyModeCategory> ALLOWED_SAFETY_MODES = Arrays.asList(SafetyModeCategory.NORMAL, SafetyModeCategory.REDUCED, SafetyModeCategory.RECOVERY, SafetyModeCategory.VALIDATE_JOINT_ID, SafetyModeCategory.SAFEGUARD_STOP, SafetyModeCategory.THREE_POSITION_ENABLING_STOP);

    @Inject
    PoweredOnRobotRequirement(FailedRequirementListener failedRequirementListener) {
        super(failedRequirementListener);
    }

    protected boolean isFulfilled() {
        RobotState robotState = RobotState.getLatestRobotState();
        return robotState.robotMode == RobotMode.RUNNING && this.allowedSafetyModes(robotState);
    }

    private boolean allowedSafetyModes(RobotState robotState) {
        SafetyModeCategory safetyModeCategory = SafetyModes.getSafetyModeCategory((SafetyMode)robotState.masterSafetyState);
        return ALLOWED_SAFETY_MODES.contains(safetyModeCategory);
    }
}

