/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.initializerobot.veto;

import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.util.logging.Log;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ModeVetoListener
implements VetoListener {
    private final Map<VetoListener.VetoType, HashSet<Object>> vetoTypes = new EnumMap<VetoListener.VetoType, HashSet<Object>>(VetoListener.VetoType.class);
    private final VetoListener.VetoType type;

    protected ModeVetoListener(VetoListener.VetoType type) {
        this.type = type;
        this.vetoTypes.put(type, new HashSet());
    }

    @Override
    public void veto(Class<?> vetoProvider, VetoListener.VetoType type) {
        HashSet<Object> vetoers = this.vetoTypes.get((Object)type);
        if (vetoers != null) {
            vetoers.add(vetoProvider);
            Log.trace((String)("\n\tAdded veto: " + vetoProvider + "\n\tNow have " + vetoers.size() + " left"));
        }
    }

    @Override
    public void cancelVeto(Class<?> vetoProvider, VetoListener.VetoType type) {
        HashSet<Object> vetoers = this.vetoTypes.get((Object)type);
        if (vetoers != null) {
            if (vetoers.remove(vetoProvider) && vetoers.isEmpty()) {
                this.vetoSetEmpty();
            }
            Log.trace((String)("\n\tRemoved veto: " + vetoProvider + "\n\tNow have " + vetoers.size() + " left"));
        }
    }

    public abstract void vetoSetEmpty();

    public boolean isNotVetoed(VetoListener.VetoType type) {
        HashSet<Object> vetoers = this.vetoTypes.get((Object)type);
        if (vetoers != null) {
            return vetoers.isEmpty();
        }
        return true;
    }

    @Override
    public void clearState(VetoListener.VetoType type) {
        if (type == this.type) {
            this.doClearState();
        }
    }

    public abstract void doClearState();

    public static class Template
    extends ModeVetoListener {
        public Template(VetoListener.VetoType type) {
            super(type);
        }

        @Override
        public void vetoSetEmpty() {
        }

        @Override
        public void doClearState() {
        }
    }
}

