/*
 * Decompiled with CFR 0.152.
 */
package com.ur.osgi.urcap;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.URCapStartFilter;
import com.ur.polyscope.urcaps.contributions.compatibility.BundleCompatibilityValidator;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.URCapFailureHandler;
import com.ur.urcap.osgi.URCapInstallDirProvider;
import com.ur.urcap.osgi.URCapInvalidHandler;
import com.ur.urcap.osgi.URCapProblemHandler;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.bundle.BundleUtility;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.helper.URCapHelper;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

@Singleton
public class URCapOSGiBundleStarter
implements URCapErrorLogger {
    private final BundleContext context;
    private final URCapProblemHandler problemHandler;
    private final URCapHelper urCapHelper;
    private final Map<Bundle, URCapError> notCompatibleBundles = new LinkedHashMap<Bundle, URCapError>();
    private final Map<BundleFileInfo, URCapError> notStartedBundles = new LinkedHashMap<BundleFileInfo, URCapError>();

    @Inject
    public URCapOSGiBundleStarter(FrameworkAdapter frameworkAdapter) {
        this.context = frameworkAdapter.getBundle(this.getClass()).getBundleContext();
        this.problemHandler = new URCapProblemHandler(new URCapFailureHandler(this.context), new URCapInvalidHandler(this.context), new URCapInstallDirProvider());
        this.urCapHelper = new URCapHelper(this.problemHandler);
        URCapFailureHandler.addLogger((URCapErrorLogger)this);
        URCapInvalidHandler.addLogger((URCapErrorLogger)this);
    }

    protected void startURCapBundles(Set<URCapStartFilter> urCapStartFilters, BundleCompatibilityValidator bundleCompatibilityValidator, ThirdPartyBundleManager thirdPartyBundleManager) {
        List bundlesToStart = this.urCapHelper.getBundlesToStart(this.context, urCapStartFilters.toArray(new URCapStartFilter[0]), bundleCompatibilityValidator);
        for (Bundle bundle : bundlesToStart) {
            try {
                Log.info((String)("Starting URCAP Bundle: " + bundle.getSymbolicName()));
                bundle.start(1);
            }
            catch (BundleException e) {
                URCapFailureHandler.FailureType failureType = this.problemHandler.getFailureHandler().logFailure(bundle, (Exception)((Object)e));
                if (failureType == URCapFailureHandler.FailureType.UNKNOWN) {
                    Log.error((String)"Error starting bundle.", (Throwable)e);
                    continue;
                }
                this.urCapHelper.getFilteredBundlesNotStarting().add(bundle);
            }
        }
        try {
            ArrayList<Bundle> knownBundles = new ArrayList<Bundle>(bundlesToStart);
            knownBundles.addAll(this.urCapHelper.getFilteredBundlesNotStarting());
            knownBundles.addAll(this.notCompatibleBundles.keySet());
            this.processUnknownJars(this.urCapHelper.getURCapPaths(knownBundles), knownBundles, this.problemHandler.getInstallDirProvider().getInstallDir());
        }
        catch (Exception e) {
            Log.error((String)"Error processing URCaps", (Throwable)e);
        }
        ArrayList allThirdPartyBundles = this.urCapHelper.getThirdPartyBundles(this.context);
        thirdPartyBundleManager.setBundles((List)allThirdPartyBundles, bundlesToStart, this.notCompatibleBundles, this.notStartedBundles);
    }

    private void processUnknownJars(HashSet<String> knownURCaps, List<Bundle> bundles, File dir) throws IOException {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar");
            }

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return "zip".equalsIgnoreCase(file.getName());
            }

            public boolean accept(File dir, String name) {
                return "zip".equalsIgnoreCase(name);
            }
        });
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            if (BundleUtility.hasManifestFile((File)file) && BundleUtility.isThirdPartyURCap((File)file)) {
                this.logErrorIfNotStarted(file, bundles);
                continue;
            }
            if (knownURCaps.contains(file.getCanonicalPath())) continue;
            this.problemHandler.getInvalidHandler().logInvalidURCap(file);
        }
    }

    private void logErrorIfNotStarted(File file, List<Bundle> bundles) {
        boolean bundleStarted = false;
        for (Bundle bundle : bundles) {
            if (!BundleUtility.isSameFile((File)file, (Bundle)bundle)) continue;
            bundleStarted = true;
            break;
        }
        if (!bundleStarted) {
            this.problemHandler.getInvalidHandler().logInvalidURCap(file);
        }
    }

    public void logError(URCapError error) {
        BundleFileInfo bundleFileInfo;
        Bundle bundle = error.getBundle();
        if (bundle != null) {
            this.notCompatibleBundles.put(bundle, error);
        }
        if ((bundleFileInfo = error.getBundleFileInfo()) != null) {
            this.notStartedBundles.put(bundleFileInfo, error);
        }
    }
}

