/*
 * Decompiled with CFR 0.152.
 */
package com.ur.osgi.urcap;

import com.ur.osgi.urcap.ServiceDereferencer;
import com.ur.polyscope.osgi.urcap.extrapackages.GeomFeatureUrcapApiExportPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.GripperUrcapApiExportPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.PolyscopeInstallationUrcapApiPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.PolyscopePayloadUrcapApiPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.PolyscopeTcpUrcapApiPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.PolyscopeUrcapUrcapApiPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.PolyscopeValueObjectsUrcapApiPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.ScrewdrivingUrcapApiExportPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.UrcapApiExportPackages;
import com.ur.polyscope.osgi.urcap.extrapackages.UrcapApiExportRobotmovementPackages;
import com.ur.util.logging.Log;
import java.io.File;
import java.util.HashMap;
import javax.inject.Singleton;
import org.apache.felix.framework.Felix;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

@Singleton
public class URCapOSGiFramework {
    private static final String EXTRA_PACKAGES_URCAP = PolyscopeUrcapUrcapApiPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_ROBOTMOVEMENT = UrcapApiExportRobotmovementPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_TCP = PolyscopeTcpUrcapApiPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_PAYLOAD = PolyscopePayloadUrcapApiPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_VALUE_OBJECTS = PolyscopeValueObjectsUrcapApiPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_GEOM_FEATURE = GeomFeatureUrcapApiExportPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_TOOLBAR = UrcapApiExportPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_GRIPPER = GripperUrcapApiExportPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_SCREWDRIVING = ScrewdrivingUrcapApiExportPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_INSTALLATION = PolyscopeInstallationUrcapApiPackages.getExtraPackages();
    private static final String EXTRA_PACKAGES_URCAPS = EXTRA_PACKAGES_URCAP + "," + EXTRA_PACKAGES_SCREWDRIVING + "," + EXTRA_PACKAGES_INSTALLATION + "," + EXTRA_PACKAGES_GRIPPER + "," + EXTRA_PACKAGES_TOOLBAR + "," + EXTRA_PACKAGES_GEOM_FEATURE + "," + EXTRA_PACKAGES_TCP + "," + EXTRA_PACKAGES_PAYLOAD + "," + EXTRA_PACKAGES_VALUE_OBJECTS + "," + EXTRA_PACKAGES_ROBOTMOVEMENT;
    private static final String EXTRA_PACKAGES_SYSTEM = "sun.reflect,sun.misc,com.sun.jna,com.sun.jna.win32,com.sun.jna.platform.win32";
    private static final String DANGEROUSLY_PASSTHROUGH_PACKAGES = "javax.annotation,javax.xml.bind,org.apache.commons.httpclient,org.apache.commons.httpclient.auth,org.apache.commons.httpclient.methods,org.apache.commons.httpclient.params,org.apache.commons.io;version=\"1.9.0\",org.apache.ws.commons.serialize,org.apache.ws.commons.util";
    private Felix felix;
    private File bundleDir = new File("urcap/bundle");

    public URCapOSGiFramework() {
        this.ensureBundleDirExists();
    }

    public void start(BundleContext hostContext) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.osgi.framework.storage", "urcap/felix-cache");
        config.put("org.osgi.framework.system.packages.extra", "sun.reflect,sun.misc,com.sun.jna,com.sun.jna.win32,com.sun.jna.platform.win32,javax.annotation,javax.xml.bind,org.apache.commons.httpclient,org.apache.commons.httpclient.auth,org.apache.commons.httpclient.methods,org.apache.commons.httpclient.params,org.apache.commons.io;version=\"1.9.0\",org.apache.ws.commons.serialize,org.apache.ws.commons.util," + EXTRA_PACKAGES_URCAPS);
        config.put("org.osgi.framework.storage.clean", "onFirstInit");
        config.put("felix.log.level", "4");
        config.put("org.osgi.framework.bootdelegation", "sun.*,com.sun.*,org.w3c.dom.*");
        config.put("org.osgi.framework.startlevel.beginning", "1");
        this.felix = new Felix(config);
        try {
            this.felix.start();
            Log.info((String)"URCap OSGi container starting");
        }
        catch (BundleException e) {
            throw new URCapOSGiStartException("Failed to start OSGi Container for URCap", e);
        }
        this.passthroughServiceRegistration(hostContext);
        this.installBundles(this.bundleDir);
        this.announceStarted();
    }

    public void announceStarted() {
        ((FrameworkStartLevel)this.felix.adapt(FrameworkStartLevel.class)).setStartLevel(8, new FrameworkListener[0]);
        Log.info((String)"URCap OSGi container fully started");
    }

    private void passthroughServiceRegistration(BundleContext hostContext) {
        this.felix.getBundleContext().addServiceListener(serviceEvent -> {
            if (serviceEvent.getType() == 1) {
                ServiceDereferencer dereference = new ServiceDereferencer(serviceEvent.getServiceReference());
                String clazz = dereference.getObjectClasses()[0];
                Object object = this.felix.getBundleContext().getService(dereference.getServiceReference());
                hostContext.registerService(clazz, object, null);
            }
        });
    }

    private void installBundles(File bundleDir) {
        for (String path : bundleDir.list()) {
            if (path.endsWith(".jar")) {
                try {
                    this.felix.getBundleContext().installBundle("file:" + bundleDir.getAbsolutePath() + "/" + path);
                    continue;
                }
                catch (BundleException e) {
                    throw new URCapOSGiStartException(e);
                }
            }
            File newBundleDir = new File(bundleDir.getAbsolutePath(), path);
            if (!newBundleDir.isDirectory()) continue;
            this.installBundles(newBundleDir);
        }
    }

    private void ensureBundleDirExists() {
        if (!this.bundleDir.exists()) {
            this.bundleDir.mkdirs();
        }
    }

    public BundleContext getBundleContext() {
        return this.felix.getBundleContext();
    }

    public File getBundleDirectory() {
        return this.bundleDir;
    }

    private static class URCapOSGiStartException
    extends RuntimeException {
        public URCapOSGiStartException(BundleException e) {
            super(e);
        }

        public URCapOSGiStartException(String message, BundleException e) {
            super(message, e);
        }
    }
}

