/*
 * Decompiled with CFR 0.152.
 */
package com.ur.osgi.urcap.framework.adapter;

import com.ur.osgi.urcap.URCapOSGiFramework;
import com.ur.urcap.osgi.infrastructure.URCapInstallInfrastructureUtil;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;

public class URCapFrameworkUtil
implements URCapInstallInfrastructureUtil {
    private final URCapOSGiFramework framework;

    @Inject
    public URCapFrameworkUtil(URCapOSGiFramework framework) {
        this.framework = framework;
    }

    public void deleteFile(String file) {
        int index = file.indexOf("file:");
        if (index > -1) {
            file = file.substring(index + 5);
        }
        this.delete(new File(file));
    }

    public void delete(File file) {
        file.delete();
    }

    public void copyFile(File urCapFile, File destFile) throws IOException {
        if (destFile == null) {
            return;
        }
        File dir = new File(URCapsServiceImpl.THIRD_PARTY_BUNDLE_INSTALL_DIR);
        if (!dir.exists()) {
            this.makeDir(dir);
        }
        this.copy(urCapFile, destFile);
    }

    public void makeDir(File dir) {
        dir.mkdir();
    }

    public void copy(File srcFile, File destFile) throws IOException {
        FileUtils.copy((File)srcFile, (File)destFile);
    }

    public void createURCapSymlink(File urcapFolder) {
        try {
            File urcapSymLinkFolder = this.getSymLinkFolder();
            if (urcapFolder == null || urcapSymLinkFolder == null) {
                return;
            }
            Process symLinkProcess = this.createSymLinkProcess(urcapFolder, urcapSymLinkFolder);
            this.runProcess(symLinkProcess);
        }
        catch (Exception e) {
            Log.warning((String)("Failed to create symLink to: " + urcapFolder.getAbsolutePath()), (Throwable)e);
        }
    }

    private void runProcess(Process process) throws InterruptedException {
        process.waitFor();
        process.destroy();
    }

    public Process createSymLinkProcess(File urcapFolder, File urcapSymLinkFolder) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"ln", "-s", urcapFolder.getAbsolutePath(), urcapSymLinkFolder.getAbsolutePath()});
    }

    public boolean hasSymLink() {
        return true;
    }

    public File getSymLinkFolder() {
        return this.getBundleDirectory();
    }

    private File getBundleDirectory() {
        return this.framework.getBundleDirectory();
    }

    private boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }
}

