/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security;

import com.ur.polyscope.security.SafetyType;
import com.ur.polyscope.security.UserAccessState;
import com.ur.view.constants.dev.OperationalMode;

public interface PrivilegeRestriction {
    public static final PrivilegeRestriction NO_RESTRICTION = new PrivilegeRestriction(){

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            return false;
        }
    };
    public static final PrivilegeRestriction RESTRICT_FOR_AUTOMATIC = new PrivilegeRestriction(){

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            return userAccessState.getOperationalMode() == OperationalMode.AUTOMATIC;
        }
    };
    public static final PrivilegeRestriction RESTRICT_FOR_AUTOMATIC_WHEN_STRICT = new PrivilegeRestriction(){

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            OperationalMode operationalMode = userAccessState.getOperationalMode();
            return operationalMode == OperationalMode.AUTOMATIC && userAccessState.getSafetyType() == SafetyType.STRICT;
        }
    };
    public static final PrivilegeRestriction RESTRICT_FOR_MANUAL_WHEN_STRICT = new PrivilegeRestriction(){

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            OperationalMode operationalMode = userAccessState.getOperationalMode();
            return operationalMode == OperationalMode.MANUAL && userAccessState.getSafetyType() == SafetyType.STRICT;
        }
    };

    public boolean isRestrictedIn(UserAccessState var1);
}

