/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PrivilegeChangeListener;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.PrivilegeStrategy;
import com.ur.polyscope.security.UserAccessState;
import com.ur.security.Privilege;
import com.ur.util.event.EventNotificationService;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;

public abstract class PrivilegeRestrictionStrategy<L extends Enum<L>>
implements PrivilegeStrategy<L>,
PrivilegeChangeListener {
    private final List<Privilege<L>> privileges = new ArrayList<Privilege<L>>();
    private UserAccessState currentState = UserAccessState.DEFAULT;

    public PrivilegeRestrictionStrategy() {
        EventNotificationService.register((Object)this, PrivilegeChangeListener.class, (Object)this);
    }

    @Override
    public void register(Privilege<L> privilege) {
        if (!this.privileges.contains(privilege)) {
            this.privileges.add(privilege);
        }
        this.updateRestriction(privilege);
    }

    @Override
    public void update(Privilege<L> privilege) {
        this.register(privilege);
    }

    @Override
    public void privilegeChanged(UserAccessState currentState) {
        this.currentState = currentState;
        for (Privilege<L> privilege : this.privileges) {
            this.updateRestriction(privilege);
        }
    }

    private void updateRestriction(Privilege<L> privilege) {
        PrivilegeRestriction restriction = this.getRestriction(privilege);
        if (restriction != null && restriction.isRestrictedIn(this.currentState)) {
            privilege.addMaximumRestriction((Object)this, this.getRestrictedLevel());
        } else {
            privilege.removeRestrictions((Object)this);
        }
    }

    protected PrivilegeRestriction getRestriction(Privilege<L> privilege) {
        return (PrivilegeRestriction)privilege.get(PrivilegeRestriction.class);
    }

    protected abstract L getRestrictedLevel();

    @Singleton
    public static class LockablePrivilegeLevelStrategy
    extends PrivilegeRestrictionStrategy<LockablePrivilegeLevel> {
        @Override
        public Class<LockablePrivilegeLevel> getLevelType() {
            return LockablePrivilegeLevel.class;
        }

        @Override
        protected LockablePrivilegeLevel getRestrictedLevel() {
            return LockablePrivilegeLevel.DENIED;
        }

        @Override
        protected PrivilegeRestriction getRestriction(Privilege<LockablePrivilegeLevel> privilege) {
            PrivilegeRestriction result = super.getRestriction(privilege);
            if (result == null && EqualsUtil.equalsOneOf((Object)privilege.get(PasswordManager.Lock.class), (Object[])new PasswordManager.Lock[]{PasswordManager.Lock.GENERAL, PasswordManager.Lock.GENERAL_WHEN_ENTERING_SET_PASSWORD_PANEL})) {
                result = PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC;
            }
            return result;
        }
    }
}

