/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security;

import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.PrivilegeStrategy;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeLevelChangeListener;
import com.ur.util.event.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Privileges {
    private final RestrictedPointToPrivilegeMap restrictedPointToPrivilege = new RestrictedPointToPrivilegeMap();
    private final LevelTypeToStrategiesMap levelTypeToStrategies = new LevelTypeToStrategiesMap();

    @Inject
    public Privileges(Set<PrivilegeStrategy> strategies) {
        for (PrivilegeStrategy each : strategies) {
            this.addStrategy(each);
        }
    }

    private <L extends Enum<L>> void addStrategy(PrivilegeStrategy<L> strategy) {
        Class<L> levelType = Privileges.getLevelType(strategy);
        this.levelTypeToStrategies.addStrategy(levelType, strategy);
    }

    private <L extends Enum<L>> void registerPrivileges(Class<L> levelType, Privilege<L> privilege) {
        for (PrivilegeStrategy<L> each : this.levelTypeToStrategies.getStrategies(levelType)) {
            each.register(privilege);
        }
    }

    public <L extends Enum<L>> void setPrivilege(RestrictedPoint<L> restrictedPoint, Privilege<L> privilege) {
        this.restrictedPointToPrivilege.get(restrictedPoint).set(privilege);
        for (PrivilegeStrategy<L> each : this.levelTypeToStrategies.getStrategies(restrictedPoint.getLevelType())) {
            each.update(this.restrictedPointToPrivilege.get(restrictedPoint));
        }
    }

    public <L extends Enum<L>> Privilege<L> getPrivilege(RestrictedPoint<L> type) {
        return this.restrictedPointToPrivilege.get(type);
    }

    private static <L extends Enum<L>> Class<L> getLevelType(PrivilegeStrategy<L> privilegeStrategy) {
        return privilegeStrategy.getLevelType();
    }

    private class LevelTypeToStrategiesMap {
        private final Map<Object, Collection<Object>> map = new HashMap<Object, Collection<Object>>();

        LevelTypeToStrategiesMap() {
        }

        <L extends Enum<L>> void addStrategy(Class<L> levelType, PrivilegeStrategy<L> strategy) {
            if (this.map.get(levelType) == null) {
                this.map.put(levelType, new ArrayList());
            }
            this.map.get(levelType).add(strategy);
        }

        <L extends Enum<L>> Iterable<PrivilegeStrategy<L>> getStrategies(Class<L> levelType) {
            ArrayList<PrivilegeStrategy<L>> result = new ArrayList<PrivilegeStrategy<L>>();
            Collection<Object> strategies = this.map.get(levelType);
            if (strategies != null) {
                for (Object each : strategies) {
                    result.add((PrivilegeStrategy)each);
                }
            }
            return result;
        }
    }

    private class RestrictedPointToPrivilegeMap {
        private final Map<Object, Object> map = new HashMap<Object, Object>();

        RestrictedPointToPrivilegeMap() {
        }

        <L extends Enum<L>> void put(RestrictedPoint<L> point, PrivilegeProxy<L> privilege) {
            this.map.put(point, privilege);
        }

        <L extends Enum<L>> PrivilegeProxy<L> get(RestrictedPoint<L> point) {
            PrivilegeProxy result = (PrivilegeProxy)this.map.get(point);
            if (result == null) {
                Class<L> levelType = point.getLevelType();
                Enum defaultLevel = (Enum)this.getDefaultLevel(levelType);
                result = new PrivilegeProxy(Privileges.this, point.name(), defaultLevel);
                Privileges.this.restrictedPointToPrivilege.put(point, result);
                Privileges.this.registerPrivileges(levelType, result);
            }
            return result;
        }

        private <L> L getDefaultLevel(Class<L> levelType) {
            L[] levels = levelType.getEnumConstants();
            if (levels == null || levels.length == 0) {
                throw new IllegalArgumentException("At least one level enum constant is required");
            }
            return levels[levels.length - 1];
        }
    }

    public static class PlaceHolderStrategy
    implements PrivilegeStrategy<LockablePrivilegeLevel> {
        @Override
        public Class<LockablePrivilegeLevel> getLevelType() {
            return LockablePrivilegeLevel.class;
        }

        @Override
        public void register(Privilege<LockablePrivilegeLevel> privilege) {
        }

        @Override
        public void update(Privilege<LockablePrivilegeLevel> privilege) {
        }
    }

    public static class PrivilegeProxy<L extends Enum<L>>
    implements Privilege<L> {
        private final List<PrivilegeLevelChangeListener<L>> listeners;
        private final String name;
        private Privilege<L> delegate;
        final /* synthetic */ Privileges this$0;

        public PrivilegeProxy(String name, L defaultPrivilege) {
            this.this$0 = this$0;
            this.name = name;
            this.delegate = new Privilege.Null(defaultPrivilege);
            this.listeners = new CopyOnWriteArrayList<PrivilegeLevelChangeListener<L>>();
        }

        public L getLevel() {
            return (L)this.delegate.getLevel();
        }

        public void addMaximumRestriction(Object restrictionOwner, L maximalLevel) {
            L oldLevel = this.getLevel();
            this.delegate.addMaximumRestriction(restrictionOwner, maximalLevel);
            L newLevel = this.getLevel();
            this.notifyLevelChange(oldLevel, newLevel);
        }

        public void removeRestrictions(Object restrictionOwner) {
            L oldLevel = this.getLevel();
            this.delegate.removeRestrictions(restrictionOwner);
            L newLevel = this.getLevel();
            this.notifyLevelChange(oldLevel, newLevel);
        }

        public <T> T get(Class<T> key) {
            return (T)(this.delegate == null ? null : this.delegate.get(key));
        }

        public <T> Collection<T> getCollection(Class<T> key) {
            return this.delegate.getCollection(key);
        }

        void set(Privilege<?> privilege) {
            L oldLevel = this.getLevel();
            this.delegate = privilege;
            this.notifyLevelChange(oldLevel, this.getLevel());
        }

        public Subscription addLevelChangeListener(final PrivilegeLevelChangeListener<L> listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            return new Subscription(){

                public void dispose() {
                    PrivilegeProxy.this.listeners.remove(listener);
                }
            };
        }

        private void notifyLevelChange(L oldLevel, L newLevel) {
            if (oldLevel != newLevel) {
                for (PrivilegeLevelChangeListener<L> each : this.listeners) {
                    each.levelChanged(oldLevel, newLevel);
                }
            }
        }

        public String toString() {
            return this.name + ": " + this.getLevel();
        }
    }
}

