/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security;

import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UserRoleManager {
    private UserRole activeRole = UserRole.NONE;
    private EventManager manager;

    @Inject
    public UserRoleManager(EventManager manager) {
        this.manager = manager;
    }

    public UserRole getActiveUserRole() {
        return this.activeRole;
    }

    public boolean setActiveUserRole(UserRole newUserRole) {
        if (newUserRole == null || this.activeRole == newUserRole) {
            return false;
        }
        this.activeRole = newUserRole;
        this.manager.fireEvent(RoleChangeListener.class, (NotificationStrategy)new NotificationStrategy<RoleChangeListener>(){

            public void notify(RoleChangeListener listener) {
                listener.roleChanged(UserRoleManager.this.getActiveUserRole());
            }
        });
        return true;
    }

    public static interface RoleChangeListener {
        public void roleChanged(UserRole var1);
    }

    public static enum UserRole {
        NONE,
        MANUAL,
        AUTOMATIC,
        RESTRICTED,
        LOCKED;

    }
}

