/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl;

import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.conveyortracking.i18n.impl.TextLabelsImpl;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorInstallationFacade;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;
import com.ur.urcap.conveyortracking.impl.io.DigitalIoProvider;
import com.ur.urcap.conveyortracking.impl.utils.ConveyorType;
import com.ur.urcap.conveyortracking.impl.utils.EncoderType;
import com.ur.urcap.conveyortracking.impl.utils.IncrementalModeType;
import java.util.List;
import java.util.Locale;

public class PersistConveyor {
    static final String ENABLED = "enabled";
    static final String APIN = "apin";
    static final String BPIN = "bpin";
    static final String TPM = "tpm";
    static final String TPR = "tpr";
    static final String ROTATE_TOOL = "rotateTool";
    static final String CONVEYOR_TYPE = "conveyorType";
    static final String INCREMENTAL_MODE = "incrementalMode";
    static final String ENCODER_TYPE = "encoderType";
    static final String DIRECTION = "direction";
    static final String CENTER_POINT = "centerPoint";
    static final String SELECTED_MODBUS = "selectedModbus";
    static final String SWITCH_DIRECTION = "switchDirection";
    private InstallationAPIProvider installationAPIProvider;
    private DataModel model;
    private ConveyorInstallationFacade conveyorInstallationFacade;
    private DigitalIoProvider digitalIoProvider = new DigitalIoProvider();

    public PersistConveyor(InstallationAPIProvider installationAPIProvider, DataModel model, ConveyorInstallationFacade conveyorInstallationFacade) {
        this.installationAPIProvider = installationAPIProvider;
        this.model = model;
        this.conveyorInstallationFacade = conveyorInstallationFacade;
    }

    public void marshal(Conveyor conveyor) {
        Double ticksPerMeter = conveyor.ticksPerMinute.getAs(Length.Unit.M);
        this.model.remove(ENABLED);
        this.model.remove(APIN);
        this.model.remove(BPIN);
        this.model.remove(CONVEYOR_TYPE);
        this.model.remove(TPM);
        this.model.remove(TPR);
        this.model.remove(INCREMENTAL_MODE);
        this.model.remove(ENCODER_TYPE);
        this.model.remove(ROTATE_TOOL);
        this.model.remove(SWITCH_DIRECTION);
        this.model.remove(SELECTED_MODBUS);
        this.model.remove(CENTER_POINT);
        this.model.remove(DIRECTION);
        this.model.set(this.fixName(conveyor, ENABLED), conveyor.enabled);
        this.model.set(this.fixName(conveyor, APIN), this.getIndexOfPin(conveyor.aPin, 0));
        this.model.set(this.fixName(conveyor, BPIN), this.getIndexOfPin(conveyor.bPin, 1));
        this.model.set(this.fixName(conveyor, CONVEYOR_TYPE), conveyor.conveyorType.getIndex());
        this.model.set(this.fixName(conveyor, TPM), ticksPerMeter.intValue());
        this.model.set(this.fixName(conveyor, TPR), conveyor.ticksPerRotation);
        this.model.set(this.fixName(conveyor, INCREMENTAL_MODE), conveyor.incrementalMode.getIndex());
        this.model.set(this.fixName(conveyor, ENCODER_TYPE), conveyor.encoderType.getIndex());
        this.model.set(this.fixName(conveyor, ROTATE_TOOL), conveyor.rotateTool);
        this.model.set(this.fixName(conveyor, SWITCH_DIRECTION), conveyor.invertDirection);
        this.model.set(this.fixName(conveyor, SELECTED_MODBUS), this.getName(conveyor.getModbusIO()));
        this.model.set(this.fixName(conveyor, CENTER_POINT), this.getName(conveyor.getCenterPoint()));
        this.model.set(this.fixName(conveyor, DIRECTION), this.getName(conveyor.getDirection()));
        this.model.set("major.version", this.installationAPIProvider.getSystemAPI().getSoftwareVersion().getMajorVersion());
        this.model.set("minor.version", this.installationAPIProvider.getSystemAPI().getSoftwareVersion().getMinorVersion());
    }

    public Conveyor unMarshal(int id) {
        return new Conveyor(id, new TextLabelsImpl(Locale.getDefault()), this.conveyorInstallationFacade){
            {
                this.enabled = this.modelGet(PersistConveyor.ENABLED, false);
                this.aPin = PersistConveyor.this.getPinFromIndex(this.modelGet(PersistConveyor.APIN, 0), 0);
                this.bPin = PersistConveyor.this.getPinFromIndex(this.modelGet(PersistConveyor.BPIN, 1), 1);
                this.conveyorType = ConveyorType.values()[this.modelGet(PersistConveyor.CONVEYOR_TYPE, 0)];
                this.ticksPerMinute = PersistConveyor.this.length(this.modelGet(PersistConveyor.TPM, 0));
                this.invertDirection = this.modelGet(PersistConveyor.SWITCH_DIRECTION, false);
                this.rotateTool = this.modelGet(PersistConveyor.ROTATE_TOOL, false);
                this.ticksPerRotation = this.modelGet(PersistConveyor.TPR, 0);
                this.encoderType = EncoderType.values()[this.modelGet(PersistConveyor.ENCODER_TYPE, 0)];
                this.incrementalMode = IncrementalModeType.values()[this.modelGet(PersistConveyor.INCREMENTAL_MODE, 0)];
                this.modbusIOabsoluteCounter = this.modelGet(PersistConveyor.SELECTED_MODBUS, "");
                this.featureLineDirection = this.modelGet(PersistConveyor.DIRECTION, "");
                this.featurePointCenterPoint = this.modelGet(PersistConveyor.CENTER_POINT, "");
            }

            private String modelGet(String name, String defaultValue) {
                String fixName = PersistConveyor.this.fixName(this.id, name);
                if (this.id == 1) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                if (PersistConveyor.this.model.isSet(fixName)) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                return PersistConveyor.this.model.get(name, defaultValue);
            }

            private int modelGet(String name, int defaultValue) {
                String fixName = PersistConveyor.this.fixName(this.id, name);
                if (this.id == 1) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                if (PersistConveyor.this.model.isSet(fixName)) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                return PersistConveyor.this.model.get(name, defaultValue);
            }

            private boolean modelGet(String name, boolean defaultValue) {
                String fixName = PersistConveyor.this.fixName(this.id, name);
                if (this.id == 1) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                if (PersistConveyor.this.model.isSet(fixName)) {
                    return PersistConveyor.this.model.get(fixName, defaultValue);
                }
                return PersistConveyor.this.model.get(name, defaultValue);
            }
        };
    }

    private String fixName(Conveyor conveyor, String fieldName) {
        return this.fixName(conveyor.id, fieldName);
    }

    private String fixName(int id, String fieldName) {
        return fieldName + "_" + id;
    }

    private String getName(Object nameable) {
        if (nameable instanceof IO) {
            return ((IO)nameable).getName();
        }
        if (nameable instanceof Feature) {
            return ((Feature)nameable).getName();
        }
        return "";
    }

    private int getIndexOfPin(ConveyorIO io, int defaultIndex) {
        List<ConveyorIO> availableIOs = this.digitalIoProvider.getAvailableIOs();
        for (int i = 0; i < availableIOs.size(); ++i) {
            if (!availableIOs.get(i).equals(io)) continue;
            return i;
        }
        return defaultIndex;
    }

    private ConveyorIO getPinFromIndex(int index, int defaultIndex) {
        List<ConveyorIO> availableIOs = this.digitalIoProvider.getAvailableIOs();
        try {
            return availableIOs.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return availableIOs.get(defaultIndex);
        }
    }

    private Length length(int lengthInMeters) {
        return this.installationAPIProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory().createLength((double)lengthInMeters, Length.Unit.M);
    }
}

