/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.domain;

import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.conveyortracking.i18n.TextLabels;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorInstallationFacade;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;
import com.ur.urcap.conveyortracking.impl.utils.ConveyorType;
import com.ur.urcap.conveyortracking.impl.utils.EncoderType;
import com.ur.urcap.conveyortracking.impl.utils.IncrementalModeType;
import java.util.Collection;
import java.util.List;

public class Conveyor {
    private static final String[] NAMES = new String[]{"Conveyor 1", "Conveyor 2"};
    public final int id;
    private final Object defaultString;
    private final ConveyorInstallationFacade conveyorInstallationFacade;
    public boolean enabled;
    public ConveyorIO aPin;
    public ConveyorIO bPin;
    public Length ticksPerMinute;
    public boolean invertDirection;
    public ConveyorType conveyorType = ConveyorType.UNDEFINED;
    public int ticksPerRotation;
    public boolean rotateTool;
    public EncoderType encoderType = EncoderType.UNDEFINED;
    public IncrementalModeType incrementalMode = IncrementalModeType.UNDEFINED;
    public String featureLineDirection;
    public String modbusIOabsoluteCounter;
    public String featurePointCenterPoint;
    private FeatureLine featureDirection;
    private ModbusIO modbusIO;
    private FeaturePoint featurePoint;

    public Conveyor(int id, TextLabels labels, ConveyorInstallationFacade conveyorInstallationFacade) {
        this.id = id;
        this.defaultString = labels.disabledConveyor();
        this.conveyorInstallationFacade = conveyorInstallationFacade;
    }

    public FeatureLine getDirection() {
        if (this.featureDirection == null) {
            this.featureDirection = this.getFeatureByName(this.featureLineDirection, this.conveyorInstallationFacade.getFeatureLines());
        }
        return this.featureDirection;
    }

    public void setFeatureDirection(FeatureLine featureDirection) {
        this.featureDirection = featureDirection;
        this.featureLineDirection = this.featureDirection != null ? this.featureDirection.getName() : "";
    }

    public void setFeaturePoint(FeaturePoint featurePoint) {
        this.featurePoint = featurePoint;
        this.featurePointCenterPoint = this.featurePoint != null ? this.featurePoint.getName() : "";
    }

    public void setModbusIO(ModbusIO modbusIO) {
        this.modbusIO = modbusIO;
        this.modbusIOabsoluteCounter = this.modbusIO != null ? this.modbusIO.getName() : "";
    }

    public FeaturePoint getCenterPoint() {
        if (this.featurePoint == null) {
            this.featurePoint = this.getFeatureByName(this.featurePointCenterPoint, this.conveyorInstallationFacade.getFeaturePoints());
        }
        return this.featurePoint;
    }

    public ModbusIO getModbusIO() {
        if (this.modbusIO == null) {
            this.modbusIO = this.getIOByName(this.modbusIOabsoluteCounter, this.conveyorInstallationFacade.getAvailableAbsoluteCounters());
        }
        return this.modbusIO;
    }

    private <T extends Feature> T getFeatureByName(String name, Collection<T> features) {
        for (Feature each : features) {
            if (!each.getName().equals(name)) continue;
            return (T)each;
        }
        return null;
    }

    private <T extends IO> T getIOByName(String name, List<T> ios) {
        if (!name.isEmpty()) {
            for (IO each : ios) {
                if (!each.getName().equals(name)) continue;
                return (T)each;
            }
        }
        return null;
    }

    public String toString() {
        return NAMES[this.id] + (this.enabled ? "" : " (" + this.defaultString + ")");
    }

    public boolean isDefined() {
        if (!this.enabled) {
            return false;
        }
        if (this.encoderTypeNotDefined()) {
            return false;
        }
        if (this.conveyorType == ConveyorType.UNDEFINED) {
            return false;
        }
        if (this.conveyorType == ConveyorType.LINEAR) {
            return this.inNotNullAndDefined((Feature)this.getDirection());
        }
        return this.inNotNullAndDefined((Feature)this.getCenterPoint());
    }

    private boolean encoderTypeNotDefined() {
        EncoderType type = this.encoderType;
        if (type == EncoderType.UNDEFINED) {
            return true;
        }
        if (type == EncoderType.ABSOLUTE) {
            return !this.isAbsoluteCounterDefined();
        }
        return type == EncoderType.INCREMENTAL && this.incrementalMode == IncrementalModeType.UNDEFINED;
    }

    public void createPreamble(ScriptWriter writer) {
        if (this.encoderType == EncoderType.INCREMENTAL) {
            this.conveyorPulseDecode(writer, this.incrementalMode, this.aPin, this.bPin);
        } else {
            writer.appendLine(String.format("encoder_enable_set_tick_count(%s, %s)", this.id, 2));
            writer.defineThread("absoluteEncoder" + this.id);
            this.writeWhileTrue(writer);
            writer.end();
            writer.runThread("encoder_thread" + this.id, "absoluteEncoder" + this.id + "()");
        }
        writer.defineFunction("start_conveyor_tracking" + this.id);
        if (this.conveyorType == ConveyorType.LINEAR) {
            this.trackLinearConveyor(writer);
        } else {
            this.trackConveyorCircular(writer, this.getCenterPoint(), this.ticksPerRotation, this.rotateTool);
        }
        writer.end();
    }

    private void writeWhileTrue(ScriptWriter writer) {
        writer.whileTrue();
        this.writeEncoderAndSync(writer);
        writer.end();
    }

    private void writeEncoderAndSync(ScriptWriter writer) {
        this.encoderSetTickCount(writer, this.getModbusIO());
        writer.sync();
    }

    public void startConveyorScript(ScriptWriter writer) {
        writer.appendLine("start_conveyor_tracking" + this.id + "()");
    }

    public void stopConveyorScript(ScriptWriter writer) {
        writer.appendLine("stop_conveyor_tracking()");
    }

    private String getLinearConveyorDirection() {
        Rotation lineRotation = this.getDirection().getPose().getRotation();
        String lineRotationReferencePose = String.format("p[0,0,0,%s,%s,%s]", lineRotation.getRX(Angle.Unit.RAD), lineRotation.getRY(Angle.Unit.RAD), lineRotation.getRZ(Angle.Unit.RAD));
        if (this.invertDirection) {
            return String.format("pose_trans(%s, p[0,-1,0,0,0,0])", lineRotationReferencePose);
        }
        return String.format("pose_trans(%s, p[0,1,0,0,0,0])", lineRotationReferencePose);
    }

    private void trackLinearConveyor(ScriptWriter writer) {
        String startConveyor = String.format("track_conveyor_linear(%s, %s, %s)", this.getLinearConveyorDirection(), (int)this.ticksPerMinute.getAs(Length.Unit.M), this.id);
        writer.appendLine(startConveyor);
    }

    private void encoderSetTickCount(ScriptWriter writer, ModbusIO varName) {
        writer.appendLine(String.format("encoder_set_tick_count(%s, modbus_get_signal_status(\"%s\"))", this.id, varName.getName()));
    }

    private void conveyorPulseDecode(ScriptWriter writer, IncrementalModeType mode, ConveyorIO inputA, ConveyorIO inputB) {
        if (mode == IncrementalModeType.QUADRATURE) {
            writer.appendLine(String.format("encoder_enable_pulse_decode(%s, %s, %s, %s)", this.id, mode.getIndex(), inputA.getPinNumber(), inputB.getPinNumber()));
        } else {
            writer.appendLine(String.format("encoder_enable_pulse_decode(%s, %s, %s, %s)", this.id, mode.getIndex(), inputA.getPinNumber(), 0));
        }
    }

    private void trackConveyorCircular(ScriptWriter writer, FeaturePoint point, int tpr, boolean rotateTool) {
        String rotateToolAsString = rotateTool ? "True" : "False";
        String centerPoint = point.isVariable() ? point.toString() : point.getPose().toString();
        writer.appendLine(String.format("track_conveyor_circular(%s, %s, %s, %s)", centerPoint, tpr, rotateToolAsString, this.id));
    }

    private boolean inNotNullAndDefined(Feature feature) {
        return feature != null && feature.isDefined();
    }

    protected boolean isAbsoluteCounterDefined() {
        ModbusIO currentModbusIO = this.getModbusIO();
        if (currentModbusIO == null) {
            return false;
        }
        String absoluteCounterName = currentModbusIO.getName();
        List<ModbusIO> ios = this.conveyorInstallationFacade.getAvailableAbsoluteCounters();
        for (IO iO : ios) {
            if (!absoluteCounterName.equals(iO.getName())) continue;
            return true;
        }
        return false;
    }
}

