/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.installationnode;

import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeatureModel;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;
import com.ur.urcap.conveyortracking.impl.io.DigitalIoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConveyorInstallationFacade {
    private final InstallationAPIProvider installationAPIProvider;
    private final DigitalIoProvider digitalIoProvider = new DigitalIoProvider();

    public ConveyorInstallationFacade(InstallationAPIProvider installationAPIProvider) {
        this.installationAPIProvider = installationAPIProvider;
    }

    public boolean isImperial() {
        return this.getUnitType() == UnitType.IMPERIAL;
    }

    protected UnitType getUnitType() {
        return this.installationAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
    }

    public Collection<FeatureLine> getFeatureLines() {
        FeatureModel featureModel = this.installationAPIProvider.getInstallationAPI().getFeatureModel();
        return featureModel.getGeomFeatures(FeatureLine.class);
    }

    public Collection<FeaturePoint> getFeaturePoints() {
        FeatureModel featureModel = this.installationAPIProvider.getInstallationAPI().getFeatureModel();
        return featureModel.getGeomFeatures(FeaturePoint.class);
    }

    public List<ConveyorIO> getConveyorIOs() {
        return this.digitalIoProvider.getAvailableIOs();
    }

    public List<ModbusIO> getAvailableAbsoluteCounters() {
        ArrayList<ModbusIO> result = new ArrayList<ModbusIO>();
        for (IO io : this.installationAPIProvider.getInstallationAPI().getIOModel().getIOs()) {
            if (io.getType() != IO.IOType.INTEGER || io.getInterfaceType() != IO.InterfaceType.UR_MODBUS) continue;
            result.add((ModbusIO)io);
        }
        return result;
    }

    public Length createLength(int ticksPerUnit, Length.Unit unit) {
        return this.installationAPIProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory().createLength((double)ticksPerUnit, unit);
    }
}

