/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.installationnode;

import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorParametersPanel;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorTrackingInstallationContribution;
import com.ur.urcap.conveyortracking.impl.installationnode.TrackingParameterPanel;
import com.ur.urcap.conveyortracking.impl.utils.PanelCreatorHelper;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ConveyorInstallationNodeView
implements SwingInstallationNodeView<ConveyorTrackingInstallationContribution> {
    private JComboBox<Conveyor> conveyorComboBox;
    private JCheckBox enableConveyorTracking;
    private ConveyorParametersPanel paramsPanel;
    private TrackingParameterPanel trackingPanel;
    private Dimension defaultSize;
    private JPanel mainPanel;
    private ConveyorTrackingInstallationContribution contribution;

    public void buildUI(JPanel mainPanel, ConveyorTrackingInstallationContribution contribution) {
        this.mainPanel = mainPanel;
        this.contribution = contribution;
        this.contribution.loadModel();
        Dimension mainPanelSize = mainPanel.getSize();
        this.defaultSize = new Dimension(mainPanelSize.width / 3, 30);
        this.initializeUI();
        this.conveyorComboBox.setSelectedItem(this.contribution.getConveyor(0));
        this.updateFieldsFromConveyor();
    }

    private void initializeUI() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.addHeaderPanel();
        this.addParamsPanel();
        this.addTrackingPanel();
        this.mainPanel.add(Box.createVerticalGlue());
    }

    private void addHeaderPanel() {
        this.initConveyorSelectionDropdown();
        this.initEnableConveyorCheckBox();
        JPanel headerPanel = PanelCreatorHelper.getBoxLayoutJPanel(0);
        this.conveyorComboBox.setPreferredSize(this.defaultSize);
        headerPanel.add(this.conveyorComboBox);
        headerPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        headerPanel.add(this.enableConveyorTracking);
        headerPanel.add(Box.createHorizontalGlue());
        this.mainPanel.add(headerPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void initEnableConveyorCheckBox() {
        this.enableConveyorTracking = new JCheckBox();
        this.enableConveyorTracking.setName("enableConveyorTracking");
        this.enableConveyorTracking.setFocusable(false);
        this.enableConveyorTracking.setText(this.contribution.getTextLabels().enableConveyorTracking());
        this.enableConveyorTracking.addActionListener(actionEvent -> {
            boolean value = this.enableConveyorTracking.isSelected();
            Conveyor selectedConveyor = (Conveyor)Objects.requireNonNull(this.conveyorComboBox.getSelectedItem());
            if (selectedConveyor.enabled != value) {
                selectedConveyor.enabled = value;
                this.paramsPanel.setPanelContentEnabled(value);
                this.trackingPanel.setPanelContentEnabled(value);
                this.contribution.marshall(selectedConveyor);
                this.conveyorComboBox.repaint();
                this.conveyorComboBox.revalidate();
            }
        });
    }

    private void initConveyorSelectionDropdown() {
        this.conveyorComboBox = new JComboBox<Conveyor>(new DefaultComboBoxModel<Conveyor>(this.contribution.getConveyors().toArray(new Conveyor[0])));
        this.conveyorComboBox.setName("selectConveyor");
        PanelCreatorHelper.setComponentSize(this.conveyorComboBox, this.defaultSize);
        this.conveyorComboBox.addActionListener(actionEvent -> this.updateFieldsFromConveyor());
    }

    protected void enterPanel() {
        Conveyor conveyor = (Conveyor)Objects.requireNonNull(this.conveyorComboBox.getSelectedItem());
        this.conveyorComboBox.setModel(new DefaultComboBoxModel<Conveyor>(this.contribution.getConveyors().toArray(new Conveyor[0])));
        this.conveyorComboBox.setSelectedItem(conveyor);
        this.updateFieldsFromConveyor();
    }

    private void updateFieldsFromConveyor() {
        Conveyor conveyor = (Conveyor)Objects.requireNonNull(this.conveyorComboBox.getSelectedItem());
        boolean value = conveyor.enabled;
        this.enableConveyorTracking.setSelected(value);
        this.paramsPanel.setPanelContentEnabled(value);
        this.trackingPanel.setPanelContentEnabled(value);
        this.paramsPanel.updateFieldsFromConveyor(conveyor);
        this.trackingPanel.updateFieldsFromConveyor(conveyor);
    }

    private void addTrackingPanel() {
        this.trackingPanel = new TrackingParameterPanel(this.contribution, this.defaultSize);
        this.mainPanel.add(this.trackingPanel);
    }

    private void addParamsPanel() {
        this.paramsPanel = new ConveyorParametersPanel(this.contribution, this.defaultSize);
        PanelCreatorHelper.setComponentSize(this.paramsPanel, new Dimension(this.mainPanel.getWidth(), this.mainPanel.getHeight() / 3));
        this.mainPanel.add(this.paramsPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
    }
}

