/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.installationnode;

import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.conveyortracking.i18n.TextLabels;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorTrackingInstallationContribution;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;
import com.ur.urcap.conveyortracking.impl.utils.EncoderType;
import com.ur.urcap.conveyortracking.impl.utils.IncrementalModeType;
import com.ur.urcap.conveyortracking.impl.utils.PanelCreatorHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConveyorParametersPanel
extends JPanel {
    private static final int INDENT = 20;
    private static final String INCREMENTAL_PANEL = "incrementalPanel";
    private static final String ABSOLUTE_PANEL = "absolutePanel";
    private static final String EMPTY_PANEL = "emptyPanel";
    private final CardLayout cardLayout = new CardLayout();
    private final ConveyorTrackingInstallationContribution contribution;
    private final Dimension defaultSize;
    private JPanel cardPanel;
    private JComboBox<EncoderType> encoderTypeComboBox;
    private JComboBox<IncrementalModeType> incrementalModeComboBox;
    private JComboBox<ConveyorIO> aInputComboBox;
    private JComboBox<ConveyorIO> bInputComboBox;
    private JComboBox<ModbusIO> modBusComboBox;
    private JLabel title;
    private JLabel encoderTypeLabel;
    private JLabel encoderTypeModeLabel;
    private JLabel aInputLabel;
    private JLabel bInputLabel;
    private JLabel encoderCountLabel;
    private TextLabels textLabels;
    private Conveyor selectedConveyor;

    public ConveyorParametersPanel(ConveyorTrackingInstallationContribution contribution, Dimension defaultSize) {
        this.contribution = contribution;
        this.defaultSize = defaultSize;
        this.initializePanel();
        this.showEmptyPanel();
    }

    public void incrementalEncoderModeNotChosen() {
        this.aInputComboBox.setEnabled(false);
        this.bInputComboBox.setEnabled(false);
    }

    public void incrementalEncoderModeQuadrature() {
        this.aInputComboBox.setEnabled(true);
        this.bInputComboBox.setEnabled(true);
    }

    public void incrementalEncoderModeRiseAndFall() {
        this.aInputComboBox.setEnabled(true);
        this.bInputComboBox.setEnabled(false);
    }

    public void updateFieldsFromConveyor(Conveyor conveyor) {
        this.selectedConveyor = conveyor;
        this.incrementalModeComboBox.setSelectedItem(this.selectedConveyor.incrementalMode);
        this.aInputComboBox.setSelectedItem(this.selectedConveyor.aPin);
        this.bInputComboBox.setSelectedItem(this.selectedConveyor.bPin);
        PanelCreatorHelper.selectIndexZeroIfNull(this.modBusComboBox, this.selectedConveyor.getModbusIO());
        this.encoderTypeComboBox.setSelectedItem(this.selectedConveyor.encoderType);
    }

    public void showIncrementalPanel() {
        this.incrementalModeComboBox.setSelectedItem(this.selectedConveyor.incrementalMode);
        this.cardLayout.show(this.cardPanel, INCREMENTAL_PANEL);
    }

    public void showAbsolutePanel() {
        List<ModbusIO> modbusIOList = this.contribution.getModbusIOList();
        this.modBusComboBox.setModel(new DefaultComboBoxModel<ModbusIO>(modbusIOList.toArray(new ModbusIO[0])));
        if (modbusIOList.contains(this.selectedConveyor.getModbusIO())) {
            this.modBusComboBox.setSelectedItem(this.selectedConveyor.getModbusIO());
        } else {
            this.modBusComboBox.setSelectedItem(this.modBusComboBox.getModel().getElementAt(0));
        }
        this.cardLayout.show(this.cardPanel, ABSOLUTE_PANEL);
    }

    public void showEmptyPanel() {
        this.cardLayout.show(this.cardPanel, EMPTY_PANEL);
    }

    public void setPanelContentEnabled(boolean enabled) {
        this.encoderTypeComboBox.setEnabled(enabled);
        this.bInputLabel.setEnabled(enabled);
        this.aInputLabel.setEnabled(enabled);
        this.encoderTypeModeLabel.setEnabled(enabled);
        this.encoderTypeLabel.setEnabled(enabled);
        this.aInputComboBox.setEnabled(enabled);
        this.bInputComboBox.setEnabled(enabled);
        this.modBusComboBox.setEnabled(enabled);
        this.title.setEnabled(enabled);
        this.incrementalModeComboBox.setEnabled(enabled);
        this.encoderCountLabel.setEnabled(enabled);
        this.handleShowHideInputs((IncrementalModeType)this.incrementalModeComboBox.getSelectedItem(), enabled);
    }

    private void initializePanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.textLabels = this.contribution.getTextLabels();
        this.title = new JLabel(this.textLabels.conveyorParameters());
        this.title.setPreferredSize(this.defaultSize);
        Font font = this.title.getFont();
        this.title.setFont(new Font(font.getFontName(), 1, font.getSize()));
        PanelCreatorHelper.addLabelToPanel(this.title, this, 0);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.initGlobalFields();
        this.addEncoderType();
        this.addIncrementalEncoderSubPanel();
        this.addAbsoluteEncoderSubPanel();
        JPanel emptyPanel = new JPanel();
        this.cardPanel.add((Component)emptyPanel, EMPTY_PANEL);
        this.setNames();
        this.add(this.cardPanel);
        this.add(Box.createVerticalGlue());
    }

    private void setNames() {
        this.encoderTypeComboBox.setName("encoderTypeDropdown");
        this.incrementalModeComboBox.setName("incrementalMode");
        this.aInputComboBox.setName("aInput");
        this.bInputComboBox.setName("bInput");
        this.modBusComboBox.setName("absoluteCount");
    }

    private void initGlobalFields() {
        this.encoderTypeComboBox = new JComboBox();
        this.encoderTypeComboBox.addActionListener(actionEvent -> {
            EncoderType encoderType = (EncoderType)this.encoderTypeComboBox.getSelectedItem();
            if (!this.selectedConveyor.encoderType.equals(encoderType)) {
                this.selectedConveyor.encoderType = encoderType;
                this.contribution.marshall(this.selectedConveyor);
            }
            switch (Objects.requireNonNull(encoderType)) {
                case INCREMENTAL: {
                    this.showIncrementalPanel();
                    break;
                }
                case ABSOLUTE: {
                    this.showAbsolutePanel();
                    break;
                }
                default: {
                    this.showEmptyPanel();
                }
            }
        });
        this.incrementalModeComboBox = new JComboBox();
        this.aInputComboBox = new JComboBox();
        this.bInputComboBox = new JComboBox();
        this.modBusComboBox = new JComboBox();
        this.cardPanel = new JPanel(this.cardLayout);
        PanelCreatorHelper.setComponentSize(this.encoderTypeComboBox, this.defaultSize);
        PanelCreatorHelper.setComponentSize(this.incrementalModeComboBox, this.defaultSize);
        PanelCreatorHelper.setComponentSize(this.aInputComboBox, this.defaultSize);
        PanelCreatorHelper.setComponentSize(this.bInputComboBox, this.defaultSize);
        PanelCreatorHelper.setComponentSize(this.modBusComboBox, this.defaultSize);
    }

    private void addEncoderType() {
        this.encoderTypeLabel = new JLabel(this.textLabels.encoderType());
        this.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.encoderTypeLabel, this.encoderTypeComboBox, EncoderType.values(), 20));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void addIncrementalEncoderSubPanel() {
        JPanel incrementalJPanel = PanelCreatorHelper.getBoxLayoutJPanel(1);
        this.encoderTypeModeLabel = new JLabel(this.textLabels.mode());
        this.incrementalModeComboBox.addActionListener(actionEvent -> {
            IncrementalModeType incrementalModeType = (IncrementalModeType)this.incrementalModeComboBox.getSelectedItem();
            if (!this.selectedConveyor.incrementalMode.equals(incrementalModeType)) {
                this.selectedConveyor.incrementalMode = incrementalModeType;
                this.contribution.marshall(this.selectedConveyor);
            }
            this.handleShowHideInputs(incrementalModeType, this.selectedConveyor.enabled);
        });
        incrementalJPanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.encoderTypeModeLabel, this.incrementalModeComboBox, IncrementalModeType.values(), 40));
        incrementalJPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.aInputLabel = new JLabel(this.textLabels.aInput());
        this.aInputComboBox.addItemListener(itemEvent -> {
            ConveyorIO conveyorIO = (ConveyorIO)this.contribution.getSelected(ConveyorIO.class, this.aInputComboBox);
            if (this.selectedConveyor.aPin != null && !this.selectedConveyor.aPin.equals(conveyorIO)) {
                this.selectedConveyor.aPin = conveyorIO;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        incrementalJPanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.aInputLabel, this.aInputComboBox, this.contribution.getConveyorIOList().toArray(new ConveyorIO[0]), 40));
        incrementalJPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.bInputLabel = new JLabel(this.textLabels.bInput());
        this.bInputComboBox.addItemListener(itemEvent -> {
            ConveyorIO conveyorIO = (ConveyorIO)this.contribution.getSelected(ConveyorIO.class, this.bInputComboBox);
            if (this.selectedConveyor.bPin != null && !this.selectedConveyor.bPin.equals(conveyorIO)) {
                this.selectedConveyor.bPin = conveyorIO;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        incrementalJPanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.bInputLabel, this.bInputComboBox, this.contribution.getConveyorIOList().toArray(new ConveyorIO[0]), 40));
        this.cardPanel.add((Component)incrementalJPanel, INCREMENTAL_PANEL);
    }

    private void handleShowHideInputs(IncrementalModeType incrementalModeType, boolean enabled) {
        if (!enabled) {
            incrementalModeType = IncrementalModeType.UNDEFINED;
        }
        switch (Objects.requireNonNull(incrementalModeType)) {
            case QUADRATURE: {
                this.incrementalEncoderModeQuadrature();
                break;
            }
            case RISE_FALL: 
            case RISE: 
            case FALL: {
                this.incrementalEncoderModeRiseAndFall();
                break;
            }
            default: {
                this.incrementalEncoderModeNotChosen();
            }
        }
    }

    private void addAbsoluteEncoderSubPanel() {
        JPanel absolutePanel = PanelCreatorHelper.getBoxLayoutJPanel(1);
        this.encoderCountLabel = new JLabel(this.textLabels.encoderCountVariable());
        absolutePanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.encoderCountLabel, this.modBusComboBox, this.contribution.getModbusIOList().toArray(new ModbusIO[0]), 40));
        this.cardPanel.add((Component)absolutePanel, ABSOLUTE_PANEL);
        this.modBusComboBox.addActionListener(actionEvent -> {
            ModbusIO modbusIO = (ModbusIO)this.contribution.getSelected(ModbusIO.class, this.modBusComboBox);
            if (modbusIO != null && modbusIO.equals(this.contribution.getUnselectedModbusIO()) && this.selectedConveyor.getModbusIO() != null) {
                this.selectedConveyor.setModbusIO(null);
                this.contribution.marshall(this.selectedConveyor);
            } else if (modbusIO != null && !modbusIO.equals(this.contribution.getUnselectedModbusIO()) && !modbusIO.equals(this.selectedConveyor.getModbusIO())) {
                this.selectedConveyor.setModbusIO(modbusIO);
                this.contribution.marshall(this.selectedConveyor);
            }
        });
    }
}

