/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.installationnode;

import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.conveyortracking.i18n.TextLabels;
import com.ur.urcap.conveyortracking.i18n.impl.TextLabelsImpl;
import com.ur.urcap.conveyortracking.impl.ConveyorLookup;
import com.ur.urcap.conveyortracking.impl.PersistConveyor;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorInstallationFacade;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorInstallationNodeView;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;

public class ConveyorTrackingInstallationContribution
implements InstallationNodeContribution,
ConveyorLookup {
    private final ConveyorInstallationFacade conveyorInstallationFacade;
    private final PersistConveyor persistConveyor;
    private List<Conveyor> availableConveyors = new ArrayList<Conveyor>();
    private final TextLabels textLabels;
    private final ConveyorInstallationNodeView nodeView;
    private final UnselectedFeatureLine unselectedFeatureLine = new UnselectedFeatureLine();
    private final UnselectedFeaturePoint unselectedFeaturePoint = new UnselectedFeaturePoint();
    private final UnselectedModbusIO unselectedModbusIO = new UnselectedModbusIO();

    public ConveyorTrackingInstallationContribution(ConveyorInstallationFacade conveyorInstallationFacade, PersistConveyor persistConveyor, Locale locale, ConveyorInstallationNodeView nodeView) {
        this.conveyorInstallationFacade = conveyorInstallationFacade;
        this.persistConveyor = persistConveyor;
        this.textLabels = new TextLabelsImpl(locale);
        this.nodeView = nodeView;
    }

    public void openView() {
        this.loadModel();
        this.nodeView.enterPanel();
    }

    public void loadModel() {
        if (this.availableConveyors == null || this.availableConveyors.isEmpty()) {
            this.availableConveyors = new ArrayList<Conveyor>(){
                {
                    this.add(ConveyorTrackingInstallationContribution.this.persistConveyor.unMarshal(0));
                    this.add(ConveyorTrackingInstallationContribution.this.persistConveyor.unMarshal(1));
                }
            };
        }
    }

    public void marshall(Conveyor conveyor) {
        this.persistConveyor.marshal(conveyor);
        this.updateConveyorList(conveyor);
    }

    public void closeView() {
    }

    public void generateScript(ScriptWriter writer) {
        this.loadModel();
        for (Conveyor each : this.availableConveyors) {
            if (!each.isDefined()) continue;
            each.createPreamble(writer);
        }
    }

    public void updateConveyorList(Conveyor conveyor) {
        for (int i = 0; i < 2; ++i) {
            if (conveyor == null || this.availableConveyors.get((int)i).id != conveyor.id) continue;
            this.availableConveyors.set(i, conveyor);
        }
    }

    @Override
    public Conveyor getConveyor(int index) {
        for (Conveyor entry : this.availableConveyors) {
            if (entry.id != index) continue;
            return entry;
        }
        return null;
    }

    @Override
    public List<Conveyor> getConveyors() {
        return new ArrayList<Conveyor>(this.availableConveyors);
    }

    public TextLabels getTextLabels() {
        return this.textLabels;
    }

    public int parseNumber(JTextComponent textField, int defaultValue) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public <T, E> Object getSelected(Class<T> tClass, JComboBox<E> list) {
        Object selectedItem = list.getSelectedItem();
        if (tClass.isInstance(selectedItem)) {
            return selectedItem;
        }
        return null;
    }

    public List<ConveyorIO> getConveyorIOList() {
        return this.conveyorInstallationFacade.getConveyorIOs();
    }

    public List<ModbusIO> getModbusIOList() {
        ArrayList<ModbusIO> availableAbsoluteCounters = new ArrayList<ModbusIO>();
        availableAbsoluteCounters.add(this.unselectedModbusIO);
        List<ModbusIO> modbusIOCollection = this.conveyorInstallationFacade.getAvailableAbsoluteCounters();
        if (modbusIOCollection != null) {
            availableAbsoluteCounters.addAll(modbusIOCollection);
        }
        return availableAbsoluteCounters;
    }

    public List<FeatureLine> getFeatureLines() {
        ArrayList<FeatureLine> featureLines = new ArrayList<FeatureLine>();
        featureLines.add(this.unselectedFeatureLine);
        Collection<FeatureLine> featureLineCollection = this.conveyorInstallationFacade.getFeatureLines();
        if (featureLineCollection != null) {
            featureLines.addAll(featureLineCollection);
        }
        return featureLines;
    }

    public List<FeaturePoint> getFeaturePoints() {
        ArrayList<FeaturePoint> featurePoints = new ArrayList<FeaturePoint>();
        featurePoints.add(this.unselectedFeaturePoint);
        Collection<FeaturePoint> featurePointCollection = this.conveyorInstallationFacade.getFeaturePoints();
        if (featurePointCollection != null) {
            featurePoints.addAll(featurePointCollection);
        }
        return featurePoints;
    }

    public boolean isImperial() {
        return this.conveyorInstallationFacade.isImperial();
    }

    public Length createLength(int i) {
        return this.conveyorInstallationFacade.createLength(i, this.getLengthUnitType());
    }

    public Length.Unit getLengthUnitType() {
        return this.isImperial() ? Length.Unit.IN : Length.Unit.M;
    }

    public UnselectedModbusIO getUnselectedModbusIO() {
        return this.unselectedModbusIO;
    }

    private class UnselectedFeatureLine
    implements FeatureLine {
        private UnselectedFeatureLine() {
        }

        public String getName() {
            return ConveyorTrackingInstallationContribution.this.textLabels.selectLineFeature();
        }

        public boolean isDefined() {
            return false;
        }

        public boolean isVariable() {
            return false;
        }

        public boolean isJoggable() {
            return false;
        }

        public Pose getPose() {
            return null;
        }

        public boolean isResolvable() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public FeaturePoint getPoint1() {
            return null;
        }

        public FeaturePoint getPoint2() {
            return null;
        }
    }

    private class UnselectedFeaturePoint
    implements FeaturePoint {
        private UnselectedFeaturePoint() {
        }

        public String getName() {
            return ConveyorTrackingInstallationContribution.this.textLabels.selectPointFeature();
        }

        public boolean isDefined() {
            return false;
        }

        public boolean isVariable() {
            return false;
        }

        public boolean isJoggable() {
            return false;
        }

        public Pose getPose() {
            return null;
        }

        public boolean isResolvable() {
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }

    private class UnselectedModbusIO
    implements ModbusIO {
        private UnselectedModbusIO() {
        }

        public String getIpAddress() {
            return null;
        }

        public String getSignalAddress() {
            return null;
        }

        public boolean setValue(int value) {
            return false;
        }

        public int getValue() {
            return 0;
        }

        public String getName() {
            return ConveyorTrackingInstallationContribution.this.textLabels.chooseModbus();
        }

        public String getDefaultName() {
            return this.getName();
        }

        public String toString() {
            return this.getName();
        }

        public IO.IOType getType() {
            return null;
        }

        public IO.InterfaceType getInterfaceType() {
            return null;
        }

        public boolean isInput() {
            return false;
        }

        public String getValueStr() {
            return null;
        }

        public boolean isResolvable() {
            return false;
        }
    }
}

