/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.installationnode;

import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.conveyortracking.i18n.TextLabels;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorTrackingInstallationContribution;
import com.ur.urcap.conveyortracking.impl.utils.ConveyorType;
import com.ur.urcap.conveyortracking.impl.utils.PanelCreatorHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class TrackingParameterPanel
extends JPanel {
    private static final int INDENT = 20;
    private static final int EXTRA_NUMBER_FIELD_WIDTH = 52;
    private static final String LINEAR_PANEL = "incrementalPanel";
    private static final String CIRCULAR_PANEL = "absolutePanel";
    private static final String EMPTY_PANEL = "emptyPanel";
    private final CardLayout conveyorTypeLayout = new CardLayout();
    private final CardLayout linearHintLayout = new CardLayout();
    private final CardLayout circularHintLayout = new CardLayout();
    private final ConveyorTrackingInstallationContribution contribution;
    private final Dimension defaultSize;
    private JPanel cardPanel;
    private JPanel linearHintPanel;
    private JPanel circularHintPanel;
    private JComboBox<ConveyorType> conveyorTypeComboBox;
    private NumberField linearTicksNumberField;
    private JComboBox<FeatureLine> directionComboBox;
    private JCheckBox reverseCheckBox;
    private NumberField circularNumberField;
    private JComboBox<FeaturePoint> centerComboBox;
    private JCheckBox rotateCheckBox;
    private JLabel conveorTypeLabel;
    private JLabel ticksPrMeterLabel;
    private JLabel directionLabel;
    private JLabel revereDirectionLabel;
    private JLabel ticksPrRevolutionLabel;
    private JLabel centerPointLabel;
    private JLabel rotateWithConveyorLabel;
    private JLabel title;
    private JLabel lineHintLabel;
    private JLabel pointHintLabel;
    private Conveyor selectedConveyor;
    private TextLabels textLabels;

    public TrackingParameterPanel(ConveyorTrackingInstallationContribution contribution, Dimension defaultSize) {
        this.contribution = contribution;
        this.defaultSize = defaultSize;
        this.initializePanel();
        this.showEmptyPanel();
    }

    public void updateFieldsFromConveyor(Conveyor conveyor) {
        this.selectedConveyor = conveyor;
        this.circularNumberField.setText(Integer.toString(this.selectedConveyor.ticksPerRotation));
        this.linearTicksNumberField.setText(Double.toString(this.selectedConveyor.ticksPerMinute.getAs(this.contribution.getLengthUnitType())));
        PanelCreatorHelper.selectIndexZeroIfNull(this.centerComboBox, this.selectedConveyor.getCenterPoint());
        PanelCreatorHelper.selectIndexZeroIfNull(this.directionComboBox, this.selectedConveyor.getDirection());
        this.rotateCheckBox.setSelected(this.selectedConveyor.rotateTool);
        this.reverseCheckBox.setSelected(this.selectedConveyor.invertDirection);
        this.conveyorTypeComboBox.setSelectedItem(this.selectedConveyor.conveyorType);
    }

    public void showLinearPanel() {
        List<FeatureLine> featureLines = this.contribution.getFeatureLines();
        this.directionComboBox.setModel(new DefaultComboBoxModel<FeatureLine>(featureLines.toArray(new FeatureLine[0])));
        if (featureLines.contains(this.selectedConveyor.getDirection())) {
            this.directionComboBox.setSelectedItem(this.selectedConveyor.getDirection());
        } else {
            this.directionComboBox.setSelectedItem(this.directionComboBox.getModel().getElementAt(0));
        }
        if (featureLines.size() == 1) {
            this.showLineHint();
        } else {
            this.hideLineHint();
        }
        this.conveyorTypeLayout.show(this.cardPanel, LINEAR_PANEL);
    }

    public void showCircularPanel() {
        List<FeaturePoint> featurePoints = this.contribution.getFeaturePoints();
        this.centerComboBox.setModel(new DefaultComboBoxModel<FeaturePoint>(featurePoints.toArray(new FeaturePoint[0])));
        if (featurePoints.contains(this.selectedConveyor.getCenterPoint())) {
            this.centerComboBox.setSelectedItem(this.selectedConveyor.getCenterPoint());
        } else {
            this.centerComboBox.setSelectedItem(this.centerComboBox.getModel().getElementAt(0));
        }
        this.conveyorTypeLayout.show(this.cardPanel, CIRCULAR_PANEL);
        if (featurePoints.size() == 1) {
            this.showPointHint();
        } else {
            this.hidePointHint();
        }
    }

    public void showEmptyPanel() {
        this.conveyorTypeLayout.show(this.cardPanel, EMPTY_PANEL);
    }

    public void showLineHint() {
        this.linearHintLayout.first(this.linearHintPanel);
    }

    public void hideLineHint() {
        this.linearHintLayout.last(this.linearHintPanel);
    }

    public void showPointHint() {
        this.circularHintLayout.first(this.circularHintPanel);
    }

    public void hidePointHint() {
        this.circularHintLayout.last(this.circularHintPanel);
    }

    public void setPanelContentEnabled(boolean enabled) {
        this.conveyorTypeComboBox.setEnabled(enabled);
        this.linearTicksNumberField.setEnabled(enabled);
        this.directionComboBox.setEnabled(enabled);
        this.reverseCheckBox.setEnabled(enabled);
        this.circularNumberField.setEnabled(enabled);
        this.centerComboBox.setEnabled(enabled);
        this.rotateCheckBox.setEnabled(enabled);
        this.conveorTypeLabel.setEnabled(enabled);
        this.ticksPrMeterLabel.setEnabled(enabled);
        this.directionLabel.setEnabled(enabled);
        this.revereDirectionLabel.setEnabled(enabled);
        this.ticksPrRevolutionLabel.setEnabled(enabled);
        this.centerPointLabel.setEnabled(enabled);
        this.rotateWithConveyorLabel.setEnabled(enabled);
        this.title.setEnabled(enabled);
        this.lineHintLabel.setEnabled(enabled);
        this.pointHintLabel.setEnabled(enabled);
    }

    private void initializePanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.textLabels = this.contribution.getTextLabels();
        this.addTitle();
        this.addConveyorType();
        this.addConveyorTypeCardPanel();
        this.initLineHints();
        this.addLinearConveyorSubPanel();
        this.initPointHint();
        this.addCircularConveyorSubPanel();
        this.setNames();
        this.add(Box.createHorizontalGlue());
    }

    private void setNames() {
        this.conveyorTypeComboBox.setName("conveyorType");
        this.linearTicksNumberField.setName("tpu");
        this.directionComboBox.setName("linearDirection");
        this.reverseCheckBox.setName("switchDirection");
        this.circularNumberField.setName("tpr");
        this.centerComboBox.setName("centerPoint");
        this.rotateCheckBox.setName("rotateTool");
    }

    private void addTitle() {
        this.title = new JLabel(this.textLabels.trackingParameters());
        Font font = this.title.getFont();
        this.title.setFont(new Font(font.getFontName(), 1, font.getSize()));
        PanelCreatorHelper.addLabelToPanel(this.title, this, 0);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void addConveyorTypeCardPanel() {
        this.cardPanel = new JPanel(this.conveyorTypeLayout);
        JPanel emptyPanel = new JPanel();
        this.cardPanel.add((Component)emptyPanel, EMPTY_PANEL);
        this.add(this.cardPanel);
    }

    private void initLineHints() {
        this.lineHintLabel = new JLabel(this.textLabels.lineFeatureHint());
        this.linearHintPanel = new JPanel(this.linearHintLayout);
        this.initHintLabel(this.lineHintLabel, this.linearHintPanel);
    }

    private void initPointHint() {
        this.pointHintLabel = new JLabel(this.textLabels.pointFeatureHint());
        this.circularHintPanel = new JPanel(this.circularHintLayout);
        this.initHintLabel(this.pointHintLabel, this.circularHintPanel);
    }

    public void initHintLabel(JLabel hintLabel, JPanel hintPanel) {
        Font font = hintLabel.getFont();
        hintLabel.setFont(new Font(font.getFontName(), 2, font.getSize()));
        PanelCreatorHelper.setComponentSize(hintPanel, new Dimension(1200, 30));
        PanelCreatorHelper.addLabelToPanel(hintLabel, hintPanel, 40);
        PanelCreatorHelper.addLabelToPanel(new JLabel(""), hintPanel, 0);
    }

    private void addConveyorType() {
        this.conveyorTypeComboBox = new JComboBox();
        PanelCreatorHelper.setComponentSize(this.conveyorTypeComboBox, this.defaultSize);
        this.conveyorTypeComboBox.addActionListener(actionEvent -> {
            ConveyorType conveyorType = (ConveyorType)this.conveyorTypeComboBox.getSelectedItem();
            if (!this.selectedConveyor.conveyorType.equals(conveyorType)) {
                this.selectedConveyor.conveyorType = conveyorType;
                this.contribution.marshall(this.selectedConveyor);
            }
            switch (Objects.requireNonNull(conveyorType)) {
                case LINEAR: {
                    this.showLinearPanel();
                    break;
                }
                case CIRCULAR: {
                    this.showCircularPanel();
                    break;
                }
                default: {
                    this.showEmptyPanel();
                }
            }
        });
        this.conveorTypeLabel = new JLabel(this.textLabels.conveyorType());
        this.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.conveorTypeLabel, this.conveyorTypeComboBox, ConveyorType.values(), 20));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void addLinearConveyorSubPanel() {
        JPanel linearPanel = PanelCreatorHelper.getBoxLayoutJPanel(1);
        this.linearTicksNumberField = new NumberField();
        this.linearTicksNumberField.setMode(Mode.WholeNumbers);
        this.linearTicksNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.getTicksPerUnitValidator()});
        this.linearTicksNumberField.addActionListener(actionEvent -> {
            Length length = this.contribution.createLength(this.contribution.parseNumber((JTextComponent)this.linearTicksNumberField, 0));
            if (this.selectedConveyor.ticksPerMinute != null && Double.compare(this.selectedConveyor.ticksPerMinute.getAs(this.contribution.getLengthUnitType()), length.getAs(this.contribution.getLengthUnitType())) != 0) {
                this.selectedConveyor.ticksPerMinute = length;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize((Component)this.linearTicksNumberField, new Dimension(this.defaultSize.width + 52, this.defaultSize.height));
        this.ticksPrMeterLabel = this.contribution.isImperial() ? new JLabel(this.textLabels.ticksPerInch()) : new JLabel(this.textLabels.ticksPerMeter());
        linearPanel.add(PanelCreatorHelper.createBoxLayoutNumberFieldPanel(this.ticksPrMeterLabel, this.linearTicksNumberField, 40));
        linearPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        linearPanel.add(this.linearHintPanel);
        linearPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.directionLabel = new JLabel(this.textLabels.direction());
        this.directionComboBox = new JComboBox();
        this.directionComboBox.addActionListener(actionEvent -> {
            FeatureLine featureLine = (FeatureLine)this.directionComboBox.getSelectedItem();
            if (featureLine != null && !featureLine.isDefined() && this.selectedConveyor.getDirection() != null) {
                this.selectedConveyor.setFeatureDirection(null);
                this.contribution.marshall(this.selectedConveyor);
            } else if (featureLine != null && featureLine.isDefined() && !featureLine.equals(this.selectedConveyor.getDirection())) {
                this.selectedConveyor.setFeatureDirection(featureLine);
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize(this.directionComboBox, this.defaultSize);
        linearPanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.directionLabel, this.directionComboBox, this.contribution.getFeatureLines().toArray(new FeatureLine[0]), 40));
        linearPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.reverseCheckBox = new JCheckBox();
        this.reverseCheckBox.setFocusable(false);
        this.reverseCheckBox.addActionListener(actionEvent -> {
            boolean selected = this.reverseCheckBox.isSelected();
            if (this.selectedConveyor.invertDirection != selected) {
                this.selectedConveyor.invertDirection = selected;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize(this.reverseCheckBox, this.defaultSize);
        this.revereDirectionLabel = new JLabel(this.textLabels.reverseDirection());
        linearPanel.add(PanelCreatorHelper.createBoxLayoutCheckBoxPanel(this.revereDirectionLabel, this.reverseCheckBox, 40));
        this.cardPanel.add((Component)linearPanel, LINEAR_PANEL);
    }

    private void addCircularConveyorSubPanel() {
        JPanel circularPanel = PanelCreatorHelper.getBoxLayoutJPanel(1);
        this.circularNumberField = new NumberField();
        this.circularNumberField.setMode(Mode.PositiveWholeNumbers);
        this.circularNumberField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)2.147483647E9, (UnitsConverter)UnitsConverter.NULL_CONVERTER)});
        this.circularNumberField.addActionListener(actionEvent -> {
            int ticksPerRotation = this.contribution.parseNumber((JTextComponent)this.circularNumberField, 0);
            if (this.selectedConveyor.ticksPerRotation != ticksPerRotation) {
                this.selectedConveyor.ticksPerRotation = ticksPerRotation;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize((Component)this.circularNumberField, new Dimension(this.defaultSize.width + 52, this.defaultSize.height));
        this.ticksPrRevolutionLabel = new JLabel(this.textLabels.ticksPerRevolution());
        circularPanel.add(PanelCreatorHelper.createBoxLayoutNumberFieldPanel(this.ticksPrRevolutionLabel, this.circularNumberField, 40));
        circularPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        circularPanel.add(this.circularHintPanel);
        circularPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.centerPointLabel = new JLabel(this.textLabels.centerPoint());
        this.centerComboBox = new JComboBox();
        this.centerComboBox.addActionListener(actionEvent -> {
            FeaturePoint featurePoint = (FeaturePoint)this.centerComboBox.getSelectedItem();
            if (featurePoint != null && !featurePoint.isDefined() && this.selectedConveyor.getCenterPoint() != null) {
                this.selectedConveyor.setFeaturePoint(null);
                this.contribution.marshall(this.selectedConveyor);
            } else if (featurePoint != null && featurePoint.isDefined() && !featurePoint.equals(this.selectedConveyor.getCenterPoint())) {
                this.selectedConveyor.setFeaturePoint(featurePoint);
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize(this.centerComboBox, this.defaultSize);
        circularPanel.add(PanelCreatorHelper.createBoxLayoutComboBoxPanel(this.centerPointLabel, this.centerComboBox, this.contribution.getFeaturePoints().toArray(new FeaturePoint[0]), 40));
        circularPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.rotateCheckBox = new JCheckBox();
        this.rotateCheckBox.setFocusable(false);
        this.rotateCheckBox.addActionListener(actionEvent -> {
            boolean selected = this.rotateCheckBox.isSelected();
            if (this.selectedConveyor.rotateTool != selected) {
                this.selectedConveyor.rotateTool = selected;
                this.contribution.marshall(this.selectedConveyor);
            }
        });
        PanelCreatorHelper.setComponentSize(this.rotateCheckBox, this.defaultSize);
        this.rotateWithConveyorLabel = new JLabel(this.textLabels.rotateToolWithConveyor());
        circularPanel.add(PanelCreatorHelper.createBoxLayoutCheckBoxPanel(this.rotateWithConveyorLabel, this.rotateCheckBox, 40));
        this.cardPanel.add((Component)circularPanel, CIRCULAR_PANEL);
    }

    private ValidationStrategy getTicksPerUnitValidator() {
        if (this.contribution.isImperial()) {
            return ValidationFactory.getRangeValidator((double)-2.147483648E9, (double)2.147483647E9, (UnitsConverter)UnitsConverter.NULL_CONVERTER);
        }
        return ValidationFactory.getRangeValidator((double)-5.4546084E7, (double)5.4546084E7, (UnitsConverter)UnitsConverter.NULL_CONVERTER);
    }
}

