/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.io;

import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.conveyortracking.impl.io.ConveyorIO;

class DigitalInput
implements ConveyorIO {
    private final int pinNumber;

    public DigitalInput(int pinNumber) {
        this.pinNumber = pinNumber;
    }

    public String getName() {
        return this.getDefaultName();
    }

    public String getDefaultName() {
        return "digital_in[" + this.pinNumber + "]";
    }

    public IO.IOType getType() {
        return IO.IOType.DIGITAL;
    }

    public IO.InterfaceType getInterfaceType() {
        return IO.InterfaceType.UR_STANDARD;
    }

    public boolean isInput() {
        return true;
    }

    public String getValueStr() {
        throw new IllegalStateException("ConveyorIOs does not return value strings");
    }

    public boolean isResolvable() {
        return true;
    }

    @Override
    public int getPinNumber() {
        return this.pinNumber;
    }

    public int hashCode() {
        return (this.getPinNumber() + this.getType().hashCode() + this.getInterfaceType().hashCode()) * 31;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConveyorIO) {
            ConveyorIO other = (ConveyorIO)obj;
            return this.getPinNumber() == other.getPinNumber() && this.getType() == other.getType() && this.getInterfaceType() == other.getInterfaceType();
        }
        return false;
    }
}

