/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.programnode;

import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.conveyortracking.i18n.impl.TextLabelsImpl;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorTrackingProgramNodeContribution;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorViewModel;
import com.ur.urcap.conveyortracking.impl.utils.PanelCreatorHelper;
import java.awt.Dimension;
import java.util.Locale;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ConveyorProgramNodeView
implements SwingProgramNodeView<ConveyorTrackingProgramNodeContribution> {
    private final Locale locale;
    private JComboBox<Conveyor> conveyorComboBox;
    private ConveyorViewModel viewModel;
    private UndoRedoManager undoRedoManager;

    public ConveyorProgramNodeView(ViewAPIProvider viewAPIProvider) {
        this.locale = viewAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
    }

    public void buildUI(JPanel jPanel, ContributionProvider contributionProvider) {
        TextLabelsImpl textLabels = new TextLabelsImpl(this.locale);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.getDescriptionPanel(textLabels.programNodeDescription1()));
        jPanel.add(this.getDescriptionPanel(textLabels.programNodeDescription2()));
        JPanel selectConveyorPanel = new JPanel();
        selectConveyorPanel.setLayout(new BoxLayout(selectConveyorPanel, 0));
        JLabel selectConveyorLabel = new JLabel(textLabels.selectConveyor());
        PanelCreatorHelper.setComponentSize(selectConveyorLabel, new Dimension(270, 40));
        selectConveyorPanel.add(Box.createHorizontalStrut(30));
        selectConveyorPanel.add(selectConveyorLabel);
        this.conveyorComboBox = new JComboBox();
        PanelCreatorHelper.setComponentSize(this.conveyorComboBox, new Dimension(350, 40));
        this.conveyorComboBox.addItemListener(e -> this.saveSelectedConveyor());
        selectConveyorPanel.add(this.conveyorComboBox);
        selectConveyorPanel.add(Box.createHorizontalGlue());
        selectConveyorPanel.setMaximumSize(new Dimension(1280, 50));
        jPanel.add(selectConveyorPanel);
        jPanel.add(Box.createVerticalGlue());
    }

    public void viewOpened(ConveyorViewModel viewModel, UndoRedoManager undoRedoManager) {
        this.viewModel = viewModel;
        this.undoRedoManager = undoRedoManager;
        DefaultComboBoxModel<Conveyor> comboBoxModel = new DefaultComboBoxModel<Conveyor>(viewModel.getAllConveyors().toArray(new Conveyor[0]));
        comboBoxModel.setSelectedItem(viewModel.selectedConveyor());
        this.conveyorComboBox.setModel(comboBoxModel);
    }

    private void saveSelectedConveyor() {
        if (this.viewModel != null && this.undoRedoManager != null) {
            this.undoRedoManager.recordChanges(() -> this.viewModel.setSelectedConveyor((Conveyor)Objects.requireNonNull(this.conveyorComboBox.getSelectedItem())));
        }
    }

    private JPanel getDescriptionPanel(String description) {
        JTextArea descriptionLabel = new JTextArea(description);
        descriptionLabel.setLineWrap(true);
        descriptionLabel.setWrapStyleWord(true);
        descriptionLabel.setFocusable(false);
        PanelCreatorHelper.setComponentSize(descriptionLabel, new Dimension(620, 120));
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 0));
        descriptionPanel.add(Box.createHorizontalStrut(30));
        descriptionPanel.add(descriptionLabel);
        descriptionPanel.add(Box.createHorizontalGlue());
        descriptionPanel.setMaximumSize(new Dimension(1280, 125));
        return descriptionPanel;
    }
}

