/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.programnode;

import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.conveyortracking.i18n.impl.TextLabelsImpl;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorProgramNodeView;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorViewModel;

public class ConveyorTrackingProgramNodeContribution
implements ProgramNodeContribution {
    private final TextLabelsImpl programmingTextLabels;
    private final ConveyorProgramNodeView conveyorProgramNodeView;
    private final ConveyorViewModel conveyorViewModel;
    private final UndoRedoManager undoRedoManager;

    public ConveyorTrackingProgramNodeContribution(ConveyorViewModel conveyorViewModel, ConveyorProgramNodeView conveyorProgramNodeView, ProgramAPIProvider programAPIProvider) {
        this.conveyorProgramNodeView = conveyorProgramNodeView;
        this.conveyorViewModel = conveyorViewModel;
        this.undoRedoManager = programAPIProvider.getProgramAPI().getUndoRedoManager();
        this.programmingTextLabels = new TextLabelsImpl(programAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocaleForProgrammingLanguage());
    }

    public void openView() {
        this.conveyorProgramNodeView.viewOpened(this.conveyorViewModel, this.undoRedoManager);
    }

    public void closeView() {
    }

    public String getTitle() {
        String conveyorName = this.conveyorViewModel.selectedConveyor().toString();
        return this.programmingTextLabels.tracking(conveyorName);
    }

    public boolean isDefined() {
        return this.conveyorViewModel.selectedConveyor().isDefined();
    }

    public void generateScript(ScriptWriter scriptWriter) {
        Conveyor conveyor = this.conveyorViewModel.selectedConveyor();
        conveyor.startConveyorScript(scriptWriter);
        scriptWriter.writeChildren();
        conveyor.stopConveyorScript(scriptWriter);
    }
}

