/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.programnode;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.program.ContributionConfiguration;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.conveyortracking.i18n.TextLabels;
import com.ur.urcap.conveyortracking.i18n.impl.TextLabelsImpl;
import com.ur.urcap.conveyortracking.impl.ConveyorLookup;
import com.ur.urcap.conveyortracking.impl.domain.Conveyor;
import com.ur.urcap.conveyortracking.impl.installationnode.ConveyorTrackingInstallationContribution;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorProgramNodeView;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorTrackingProgramNodeContribution;
import com.ur.urcap.conveyortracking.impl.programnode.ConveyorViewModel;
import java.util.List;
import java.util.Locale;

public class ConveyorTrackingProgramService
implements SwingProgramNodeService<ConveyorTrackingProgramNodeContribution, ConveyorProgramNodeView> {
    private ConveyorProgramNodeView conveyorProgramNodeView;

    public String getId() {
        return "ConveyorTracking";
    }

    public void configureContribution(ContributionConfiguration contributionConfiguration) {
        contributionConfiguration.setChildrenAllowed(true);
    }

    public String getTitle(Locale locale) {
        TextLabels textResource = new TextLabelsImpl(locale);
        if (FeatureToggle.isActive((String)"englishProgramming")) {
            textResource = textResource.getDefaultLocale();
        }
        return textResource.conveyorTrackingTitle();
    }

    public ConveyorProgramNodeView createView(ViewAPIProvider viewAPIProvider) {
        if (this.conveyorProgramNodeView == null) {
            this.conveyorProgramNodeView = new ConveyorProgramNodeView(viewAPIProvider);
        }
        return this.conveyorProgramNodeView;
    }

    public ConveyorTrackingProgramNodeContribution createNode(final ProgramAPIProvider programAPIProvider, ConveyorProgramNodeView conveyorProgramNodeView, DataModel dataModel, CreationContext creationContext) {
        ConveyorViewModel conveyorViewModel = new ConveyorViewModel(dataModel, new ConveyorLookup(){

            @Override
            public Conveyor getConveyor(int index) {
                return ((ConveyorTrackingInstallationContribution)programAPIProvider.getProgramAPI().getInstallationNode(ConveyorTrackingInstallationContribution.class)).getConveyor(index);
            }

            @Override
            public List<Conveyor> getConveyors() {
                return ((ConveyorTrackingInstallationContribution)programAPIProvider.getProgramAPI().getInstallationNode(ConveyorTrackingInstallationContribution.class)).getConveyors();
            }
        });
        return new ConveyorTrackingProgramNodeContribution(conveyorViewModel, conveyorProgramNodeView, programAPIProvider);
    }
}

