/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.conveyortracking.impl.utils;

import com.ur.swing.number.NumberField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class PanelCreatorHelper {
    private static final int HEADER_WIDTH = 420;
    private static final int HEADER_HEIGHT = 30;

    private PanelCreatorHelper() {
    }

    public static <T> JPanel createBoxLayoutComboBoxPanel(JLabel jLabel, JComboBox<T> jComboBox, T[] values, int indent) {
        PanelCreatorHelper.setComponentSize(jLabel, new Dimension(420 - indent, 30));
        jComboBox.setModel(new DefaultComboBoxModel<T>(values));
        JPanel jPanel = PanelCreatorHelper.getBoxLayoutJPanel(0);
        PanelCreatorHelper.addComponentWithIndent(jComboBox, indent, jLabel, jPanel);
        return jPanel;
    }

    public static JPanel createBoxLayoutNumberFieldPanel(JLabel jLabel, NumberField numberField, int indent) {
        PanelCreatorHelper.setComponentSize(jLabel, new Dimension(420 - indent, 30));
        JPanel jPanel = PanelCreatorHelper.getBoxLayoutJPanel(0);
        PanelCreatorHelper.addComponentWithIndent((JComponent)numberField, indent, jLabel, jPanel);
        return jPanel;
    }

    public static JPanel createBoxLayoutCheckBoxPanel(JLabel jLabel, JCheckBox jCheckBox, int indent) {
        PanelCreatorHelper.setComponentSize(jLabel, new Dimension(420 - indent, 30));
        JPanel jPanel = PanelCreatorHelper.getBoxLayoutJPanel(0);
        PanelCreatorHelper.addComponentWithIndent(jCheckBox, indent, jLabel, jPanel);
        return jPanel;
    }

    private static void addComponentWithIndent(JComponent jComponent, int indent, JLabel jLabel, JPanel jPanel) {
        jPanel.add(Box.createRigidArea(new Dimension(indent, 0)));
        jPanel.add(jLabel);
        jPanel.add(jComponent);
        jPanel.add(Box.createHorizontalGlue());
    }

    public static JPanel getBoxLayoutJPanel(int axis) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, axis));
        return jPanel;
    }

    public static void addLabelToPanel(JLabel label, Container addTo, int indent) {
        JPanel jPanel = PanelCreatorHelper.getBoxLayoutJPanel(0);
        jPanel.add(Box.createRigidArea(new Dimension(indent, 0)));
        jPanel.add(label);
        jPanel.add(Box.createHorizontalGlue());
        addTo.add(jPanel);
    }

    public static void setComponentSize(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
    }

    public static <T> void selectIndexZeroIfNull(JComboBox<T> jComboBox, T object) {
        if (object != null) {
            jComboBox.setSelectedItem(object);
        } else {
            jComboBox.setSelectedItem(jComboBox.getModel().getElementAt(0));
        }
    }
}

