/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution;

import com.ur.urcap.contribution.URCapSortable;
import java.util.Comparator;

public abstract class URCapDataComparator
implements Comparator<URCapSortable> {
    @Override
    public int compare(URCapSortable urCapSortable1, URCapSortable urCapSortable2) {
        int result;
        if (urCapSortable1 == null && urCapSortable2 == null) {
            return 0;
        }
        if (urCapSortable1 == null) {
            return -1;
        }
        if (urCapSortable2 == null) {
            return 1;
        }
        if (URCapDataComparator.rank(urCapSortable1.getURCapId()) < URCapDataComparator.rank(urCapSortable2.getURCapId())) {
            result = -1;
        } else if (URCapDataComparator.rank(urCapSortable1.getURCapId()) > URCapDataComparator.rank(urCapSortable2.getURCapId())) {
            result = 1;
        } else {
            result = URCapDataComparator.getComparasionResult(urCapSortable1.getURCapVendor(), urCapSortable2.getURCapVendor());
            if (result == 0) {
                result = URCapDataComparator.getComparasionResult(urCapSortable1.getURCapName(), urCapSortable2.getURCapName());
            }
            if (result == 0) {
                result = this.getSortbyTitleOrIdResult(urCapSortable1, urCapSortable2);
            }
        }
        return result;
    }

    public abstract int getSortbyTitleOrIdResult(URCapSortable var1, URCapSortable var2);

    private static int rank(String id) {
        int result = 4;
        if ("PalletNode".equals(id)) {
            result = 0;
        }
        if ("ConveyorTracking".equals(id)) {
            result = 1;
        } else if ("EthernetIP".equals(id)) {
            result = 2;
        } else if ("com.ur.urcap.profinet".equals(id)) {
            result = 3;
        }
        return result;
    }

    public static int getComparasionResult(String firstValue, String secondValue) {
        if (firstValue == null && secondValue == null) {
            return 0;
        }
        if (firstValue == null) {
            return -1;
        }
        if (secondValue == null) {
            return 1;
        }
        if (firstValue.toLowerCase().compareTo(secondValue.toLowerCase()) == 0) {
            return firstValue.compareTo(secondValue);
        }
        return firstValue.toLowerCase().compareTo(secondValue.toLowerCase());
    }
}

